/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.login.token;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.util.JwtUtil;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTokenService<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTokenService.class);
    private static final ObjectMapper objectMapper = JsonUtils.createDmcObjectMapper();

    public Class<?> getType() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public abstract String getIssuer();

    public boolean validate(String token) {
        return JwtUtil.verify((String)token, (String)this.getIssuer());
    }

    public String getToken(T data) {
        String json;
        try {
            json = objectMapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.JSON_SERIALIZER);
        }
        return JwtUtil.sign((String)json, (String)this.getIssuer());
    }

    public T getData(String token) {
        if (!this.validate(token)) {
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_TOKEN_INVALID, token);
        }
        try {
            return (T)objectMapper.readValue(JwtUtil.getData((String)token), this.getType());
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessException((ErrorHandler)CommonErrorCode.JSON_SERIALIZER);
        }
    }
}

