/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.login.token;

import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.service.login.token.AbstractTokenService;
import com.digiwin.dap.middleware.dmc.support.auth.domain.DriveAuth;
import com.digiwin.dap.middleware.dmc.support.auth.domain.DriveAuthItem;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtUser;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"2h"})
public class DriveTokenService
extends AbstractTokenService<DriveAuth> {
    @Autowired
    private BucketRepository bucketRepository;

    public String getIssuer() {
        return "DriveToken";
    }

    @Cacheable(key="'drive:token:' + #user.uniqueKey() + ':' + #data.hashCode()")
    public String getToken(DriveAuth data, JwtUser user) {
        if (!this.validate(data, user)) {
            return null;
        }
        return super.getToken((Object)data);
    }

    private boolean validate(DriveAuth data, JwtUser user) {
        List buckets = data.getItems().stream().map(DriveAuthItem::getBucket).filter(item -> item != null && !item.isEmpty()).distinct().collect(Collectors.toList());
        return this.bucketRepository.existsByNameInAndOwner(buckets, user.getUserId());
    }
}

