/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.resource.goods.impl;

import com.digiwin.dap.middleware.dmc.constant.ResourceCategoryEnum;
import com.digiwin.dap.middleware.dmc.domain.remote.cac.vo.PurchaseDetailExtVO;
import com.digiwin.dap.middleware.dmc.domain.remote.gmc.vo.GoodsVO;
import com.digiwin.dap.middleware.dmc.domain.resource.goods.use.record.vo.ResourceGoodsUsageVO;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.ResourceGoods;
import com.digiwin.dap.middleware.dmc.entity.ResourceGoodsPurchaseRecord;
import com.digiwin.dap.middleware.dmc.entity.stats.StatsDisk;
import com.digiwin.dap.middleware.dmc.repository.ResourceGoodsPurchaseRecordRepository;
import com.digiwin.dap.middleware.dmc.repository.ResourceGoodsRepository;
import com.digiwin.dap.middleware.dmc.repository.ResourceGoodsUseRecordRepository;
import com.digiwin.dap.middleware.dmc.repository.StatsDiskRepository;
import com.digiwin.dap.middleware.dmc.service.resource.goods.ResourceGoodsBizService;
import com.digiwin.dap.middleware.dmc.support.remote.GmcService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ResourceGoodsBizServiceImpl
implements ResourceGoodsBizService {
    private static final Logger logger = LoggerFactory.getLogger(ResourceGoodsBizServiceImpl.class);
    @Autowired
    private ResourceGoodsPurchaseRecordRepository resourceGoodsPurchaseRecordRepository;
    @Autowired
    private ResourceGoodsRepository resourceGoodsRepository;
    @Autowired
    private ResourceGoodsUseRecordRepository resourceGoodsUseRecordRepository;
    @Autowired
    private StatsDiskRepository statsDiskRepository;
    @Autowired
    private GmcService gmcService;

    @Transactional
    public void saveResourceGoodsPurchaseRecord(PurchaseDetailExtVO purchaseDetailExtVO, String userToken) {
        if (Objects.isNull(purchaseDetailExtVO)) {
            logger.warn("cac\u8ba1\u91cf\u5546\u54c1\u6388\u6743\u8bb0\u5f55\u4e3a\u7a7a!");
            return;
        }
        logger.info("\u540c\u6b65cac\u8ba1\u91cf\u5546\u54c1\u6388\u6743\u8bb0\u5f55,\u6388\u6743id:{}", (Object)purchaseDetailExtVO.getId());
        GoodsVO goodsVO = this.gmcService.findGoodsByCode(purchaseDetailExtVO.getProductCode(), userToken);
        if (Objects.isNull(goodsVO) || !Objects.equals(goodsVO.getResourceCategory(), ResourceCategoryEnum.DMC_STORAGE.getCategory())) {
            logger.info("\u5f53\u524d\u5546\u54c1\u4e3a\u7a7a\u6216\u8005\u975edmc\u7edf\u4e00\u5bb9\u91cf\u7c7b\u578b\u8ba1\u91cf\u5546\u54c1:{}", (Object)purchaseDetailExtVO.getProductCode());
            return;
        }
        ResourceGoodsPurchaseRecord resourceGoodsPurchaseRecord = this.resourceGoodsPurchaseRecordRepository.findByPurchaseId(purchaseDetailExtVO.getId());
        if (Objects.isNull(resourceGoodsPurchaseRecord)) {
            ResourceGoodsPurchaseRecord resp = new ResourceGoodsPurchaseRecord();
            resp.setTenantId(purchaseDetailExtVO.getCustomerId());
            resp.setProductCode(purchaseDetailExtVO.getProductCode());
            resp.setProductName(purchaseDetailExtVO.getProductName());
            resp.setOccupiedCapacity("0");
            resp.setTotalUsageCapacity(String.valueOf(this.convertGBToByte(Integer.valueOf(purchaseDetailExtVO.getTotalUsageBound()))));
            resp.setPurchaseDate(purchaseDetailExtVO.getCreateDateTime());
            resp.setPurchaseId(purchaseDetailExtVO.getId());
            resp.setEffectiveDateTime(purchaseDetailExtVO.getEffectiveDateTime());
            resp.setExpiredDateTime(purchaseDetailExtVO.getExpiredDateTime());
            this.resourceGoodsPurchaseRecordRepository.insert((ObIdEntity)resp);
            logger.info("\u65b0\u589e\u8ba1\u91cf\u5546\u54c1\u6388\u6743,\u6388\u6743id:{},\u5546\u54c1code:{},\u6388\u6743\u5bb9\u91cf:{}", new Object[]{purchaseDetailExtVO.getId(), purchaseDetailExtVO.getProductCode(), purchaseDetailExtVO.getTotalUsageBound()});
        } else {
            resourceGoodsPurchaseRecord.setTotalUsageCapacity(String.valueOf(this.convertGBToByte(Integer.valueOf(purchaseDetailExtVO.getTotalUsageBound()))));
            resourceGoodsPurchaseRecord.setPurchaseId(purchaseDetailExtVO.getId());
            resourceGoodsPurchaseRecord.setPurchaseDate(purchaseDetailExtVO.getCreateDateTime());
            resourceGoodsPurchaseRecord.setTenantId(purchaseDetailExtVO.getCustomerId());
            resourceGoodsPurchaseRecord.setProductCode(purchaseDetailExtVO.getProductCode());
            resourceGoodsPurchaseRecord.setProductName(purchaseDetailExtVO.getProductName());
            this.resourceGoodsPurchaseRecordRepository.update((ObIdEntity)resourceGoodsPurchaseRecord);
            logger.info("\u66f4\u65b0\u8ba1\u91cf\u5546\u54c1\u6388\u6743,\u6388\u6743id:{},\u5546\u54c1code:{},\u6388\u6743\u5bb9\u91cf:{},\u5f53\u524d\u5df2\u4f7f\u7528\u5bb9\u91cf:{}", new Object[]{purchaseDetailExtVO.getId(), purchaseDetailExtVO.getProductCode(), purchaseDetailExtVO.getTotalUsageBound(), resourceGoodsPurchaseRecord.getOccupiedCapacity()});
        }
        if (!CollectionUtils.isEmpty((Collection)purchaseDetailExtVO.getAppId())) {
            purchaseDetailExtVO.getAppId().forEach(appId -> {
                ResourceGoods resourceGoods = new ResourceGoods();
                resourceGoods.setAppId(appId);
                resourceGoods.setProductCode(purchaseDetailExtVO.getProductCode());
                this.resourceGoodsRepository.insert((ObIdEntity)resourceGoods);
            });
        }
    }

    @Transactional
    public void updateOccupiedCapacity(ResourceGoodsPurchaseRecord resourceGoodsPurchaseRecord, String bucket, Long occupiedCapacity, String appId) {
        long oldOccupiedCapacity = Long.parseLong(resourceGoodsPurchaseRecord.getOccupiedCapacity());
        long newOccupiedCapacity = oldOccupiedCapacity + occupiedCapacity;
        resourceGoodsPurchaseRecord.setOccupiedCapacity(String.valueOf(newOccupiedCapacity));
        this.resourceGoodsPurchaseRecordRepository.update((ObIdEntity)resourceGoodsPurchaseRecord);
    }

    public void updateOccupiedCapacity(String date) {
        List statsDisks = this.statsDiskRepository.findByDate(date);
        if (Objects.isNull(statsDisks)) {
            return;
        }
        Map<String, Long> result = statsDisks.stream().distinct().collect(Collectors.groupingBy(disk -> disk.getAppId() + "-" + disk.getTenantId(), Collectors.summingLong(StatsDisk::getSize)));
        logger.info("\u78c1\u76d8\u7edf\u8ba1\u6570\u636e:{}", (Object)JsonUtils.objToJson(result));
        ArrayList<ResourceGoodsUsageVO> resourceGoodsUsageVOList = new ArrayList<ResourceGoodsUsageVO>();
        for (Map.Entry<String, Long> entry : result.entrySet()) {
            String[] params = entry.getKey().split("-");
            String appId = params[0];
            String tenantId = params[1];
            String resourceGoods = this.resourceGoodsRepository.findProductCodeByAppId(appId);
            if (Objects.isNull(resourceGoods)) continue;
            ResourceGoodsUsageVO resourceGoodsUsageVO = new ResourceGoodsUsageVO();
            resourceGoodsUsageVO.setAppId(appId);
            resourceGoodsUsageVO.setUsageCapacity(entry.getValue());
            resourceGoodsUsageVO.setTenantId(tenantId);
            resourceGoodsUsageVO.setProductCode(resourceGoods);
            resourceGoodsUsageVOList.add(resourceGoodsUsageVO);
        }
        Map<String, List<ResourceGoodsUsageVO>> map = resourceGoodsUsageVOList.stream().collect(Collectors.groupingBy(vo -> vo.getTenantId() + "-" + vo.getProductCode()));
        logger.info("\u8ba1\u91cf\u5546\u54c1\u7ec4\u5408\u7edf\u8ba1\u6570\u636e:{}", (Object)JsonUtils.objToJson(map));
        for (Map.Entry<String, List<ResourceGoodsUsageVO>> entry : map.entrySet()) {
            String[] params = entry.getKey().split("-");
            String resourceGoods = params[1];
            String tenantId = params[0];
            this.resourceGoodsPurchaseRecordRepository.updateOccupiedCapacityByProductCodeAndTenantId(resourceGoods, tenantId, entry.getValue());
        }
    }

    @Transactional
    public void updateResourceGoods(String code, List<String> resourceCodeList, String userToken) {
        ArrayList<ResourceGoods> resourceGoodsList = new ArrayList<ResourceGoods>();
        for (String resourceCode : resourceCodeList) {
            GoodsVO goodsVO = this.gmcService.findGoodsByCode(resourceCode, userToken);
            if (Objects.isNull(goodsVO) || !Objects.equals(goodsVO.getResourceCategory(), ResourceCategoryEnum.DMC_STORAGE.getCategory())) {
                logger.warn("\u5f53\u524d\u5546\u54c1\u4e3a\u7a7a\u6216\u8005\u975edmc\u7edf\u4e00\u5bb9\u91cf\u7c7b\u578b\u8ba1\u91cf\u5546\u54c1:{}", (Object)resourceCode);
                continue;
            }
            ResourceGoods resourceGoods2 = new ResourceGoods();
            resourceGoods2.setProductCode(resourceCode);
            resourceGoods2.setAppId(code);
            resourceGoodsList.add(resourceGoods2);
        }
        this.resourceGoodsRepository.deleteByAppId(code);
        resourceGoodsList.forEach(resourceGoods -> this.resourceGoodsRepository.insert((ObIdEntity)resourceGoods));
    }

    private long convertGBToByte(Integer gb) {
        return (long)gb.intValue() << 30;
    }
}

