/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.stats;

import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.serializer.Constants;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class LmcStatsDiskDetailService
implements InitializingBean {
    public static final String BUCKET = "lmc";
    public static final String COLLECTION = "stats_disk_detail";
    private static final Logger logger = LoggerFactory.getLogger(LmcStatsDiskDetailService.class);
    @Autowired
    protected MongoTemplate mongoTemplate;
    @Autowired
    private MongoClient mongoClient;
    private MongoCollection<Document> lmcMongoCollection;

    public void afterPropertiesSet() throws Exception {
        this.lmcMongoCollection = this.mongoClient.getDatabase(BUCKET).getCollection(COLLECTION);
    }

    public void deleteById(String id) {
        this.lmcMongoCollection.deleteOne(Filters.eq((String)"_id", (Object)IdUtil.uuid((String)id)));
    }

    public PageData<?> findByPage(Page body) {
        Object filter;
        long total;
        String appId = (String)body.getFilters().get("appId");
        String queryTime = (String)body.getFilters().get("queryTime");
        ArrayList<Bson> filters = new ArrayList<Bson>();
        if (StringUtils.hasLength((String)queryTime)) {
            LocalDateTime start = LocalDateTime.parse(queryTime, Constants.DATETIME_FORMATTER);
            filters.add(Filters.gte((String)"queryTime", (Object)start.minusHours(8L)));
            filters.add(Filters.lt((String)"queryTime", (Object)start.minusHours(7L)));
        }
        if (StringUtils.hasLength((String)appId)) {
            filters.add(Filters.eq((String)"appId", (Object)appId));
        }
        if ((total = this.lmcMongoCollection.countDocuments((Bson)(filter = filters.isEmpty() ? new BsonDocument() : (filters.size() == 1 ? (Bson)filters.get(0) : Filters.and(filters))))) <= 0L) {
            return PageData.zero();
        }
        MongoCursor iterator = this.lmcMongoCollection.find((Bson)filter).sort(body.sort()).skip(body.skip()).limit(body.limit()).iterator();
        ArrayList lists = new ArrayList();
        while (iterator.hasNext()) {
            Document document = (Document)iterator.next();
            HashMap<String, Object> detail = new HashMap<String, Object>();
            detail.put("id", document.get((Object)"_id"));
            detail.put("appId", document.getString((Object)"appId"));
            detail.put("size", document.getLong((Object)"size"));
            Date date = document.getDate((Object)"queryTime");
            if (date != null) {
                detail.put("queryTime", LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
            }
            lists.add(detail);
        }
        return PageData.data((long)total, lists);
    }

    public void dropCollection() {
        logger.info("drop collection lmc.stats_disk_detail");
    }
}

