/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.service.stats.impl;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.dao.impl.FileInfoCrudServiceImpl;
import com.digiwin.dap.middleware.dmc.domain.TenantFileInfoDTO;
import com.digiwin.dap.middleware.dmc.domain.TenantVO;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.service.stats.StatsService;
import com.digiwin.dap.middleware.dmc.support.remote.IamService;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.UpdateResult;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class StatsServiceImpl
implements StatsService {
    public static final Logger logger = LoggerFactory.getLogger(StatsServiceImpl.class);
    @Autowired
    private IamService iamService;
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private FileInfoCrudServiceImpl fileInfoCrudService;

    public Map<String, Map<String, List<TenantFileInfoDTO>>> updateFileInfoTenant(Map<String, List<TenantFileInfoDTO>> body, Boolean force) {
        logger.info("\u5168\u90e8\u5f00\u59cb\u5347\u7ea7 startTime: {}", (Object)LocalDateTime.now());
        HashSet tenantSids = new HashSet();
        ArrayList allInfoDTOList = new ArrayList();
        this.checkBucket(body, tenantSids, allInfoDTOList);
        this.checkTenant(tenantSids, allInfoDTOList);
        HashMap failMap = new HashMap();
        HashMap successMap = new HashMap();
        for (Map.Entry<String, List<TenantFileInfoDTO>> entry : body.entrySet()) {
            String bucket = entry.getKey();
            long startTime = System.currentTimeMillis();
            logger.info("bucket: {}, \u5f00\u59cb\u5347\u7ea7 startTime: {}", (Object)bucket, (Object)startTime);
            MongoCollection mongoCollection = this.fileInfoCrudService.getLoginUserCollection(bucket);
            ArrayList failList = new ArrayList();
            ArrayList<TenantFileInfoDTO> successList = new ArrayList<TenantFileInfoDTO>();
            for (TenantFileInfoDTO infoDTO : entry.getValue()) {
                List fileIds = infoDTO.getFileIds();
                Bson filter = this.getFilter(force, failList, infoDTO, fileIds);
                Bson update = Updates.set((String)"tenantId", (Object)infoDTO.getTenantId());
                UpdateResult result = mongoCollection.updateMany(filter, update);
                TenantFileInfoDTO fileDTO = new TenantFileInfoDTO(infoDTO.getBucket(), infoDTO.getTenantSid(), infoDTO.getTenantId(), Collections.emptyList(), Long.valueOf(result.getMatchedCount()), Long.valueOf(result.getModifiedCount()));
                successList.add(fileDTO);
                logger.info("bucket: {}, tenantId: {}, fileIds.size: {}, \u547d\u4e2d Matched document count: {}", new Object[]{bucket, infoDTO.getTenantId(), fileIds != null ? Integer.valueOf(fileIds.size()) : "", result.getMatchedCount()});
                logger.info("bucket: {}, tenantId: {}, fileIds.size: {}, \u66f4\u65b0 Modified document count: {}", new Object[]{bucket, infoDTO.getTenantId(), fileIds != null ? Integer.valueOf(fileIds.size()) : "", result.getModifiedCount()});
            }
            if (!failList.isEmpty()) {
                failMap.put(bucket, failList);
            }
            successMap.put(bucket, successList);
            long endTime = System.currentTimeMillis();
            logger.info("bucket: {}, \u5347\u7ea7\u7ed3\u675f endTime: {}, \u8017\u65f6: {}", new Object[]{bucket, endTime, endTime - startTime});
        }
        HashMap<String, Map<String, List<TenantFileInfoDTO>>> resultMap = new HashMap<String, Map<String, List<TenantFileInfoDTO>>>();
        resultMap.put("fail", failMap);
        resultMap.put("success", successMap);
        logger.info("\u5168\u90e8\u5347\u7ea7\u7ed3\u675f endTime: {}", (Object)LocalDateTime.now());
        return resultMap;
    }

    private Bson getFilter(Boolean force, List<TenantFileInfoDTO> failList, TenantFileInfoDTO infoDTO, List<String> fileIds) {
        Bson or = Filters.or((Bson[])new Bson[]{Filters.eq((String)"tenantId", (Object)""), Filters.eq((String)"tenantId", null)});
        if (CollectionUtils.isEmpty(fileIds)) {
            if (!Boolean.TRUE.equals(force)) {
                return or;
            }
            return new BasicDBObject();
        }
        ArrayList notExistFileIds = new ArrayList();
        List uuids = fileIds.stream().map(o -> {
            try {
                return IdUtil.uuid((String)o);
            }
            catch (Exception e) {
                notExistFileIds.add(o);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        Bson filter = Filters.in((String)"_id", uuids);
        if (!Boolean.TRUE.equals(force)) {
            filter = Filters.and((Bson[])new Bson[]{filter, or});
        }
        if (!notExistFileIds.isEmpty()) {
            TenantFileInfoDTO fileDTO = new TenantFileInfoDTO(infoDTO.getBucket(), infoDTO.getTenantSid(), infoDTO.getTenantId(), notExistFileIds);
            failList.add(fileDTO);
        }
        return filter;
    }

    private void checkTenant(Set<Long> tenantSids, List<TenantFileInfoDTO> allInfoDTOList) {
        if (tenantSids.isEmpty()) {
            return;
        }
        List tenants = this.iamService.getTenantIdsBySids(tenantSids);
        List iamTenantSids = tenants.stream().map(TenantVO::getSid).collect(Collectors.toList());
        tenantSids.removeAll(iamTenantSids);
        if (!tenantSids.isEmpty()) {
            throw new BusinessException(String.format("\u83b7\u53d6\u79df\u6237%s\u4fe1\u606f\u5931\u8d25", tenantSids));
        }
        for (TenantFileInfoDTO infoDTO : allInfoDTOList) {
            for (TenantVO tenantVO : tenants) {
                if (!tenantVO.getSid().equals(infoDTO.getTenantSid())) continue;
                infoDTO.setTenantId(tenantVO.getId());
            }
            if (!ObjectUtils.isEmpty((Object)infoDTO.getTenantId())) continue;
            throw new BusinessException(String.format("bucket\u5e93[%s]\u4e0b\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a", infoDTO.getBucket()));
        }
    }

    private void checkBucket(Map<String, List<TenantFileInfoDTO>> body, Set<Long> tenantSids, List<TenantFileInfoDTO> allInfoDTOList) {
        for (Map.Entry<String, List<TenantFileInfoDTO>> entry : body.entrySet()) {
            String bucket = entry.getKey();
            if (ObjectUtils.isEmpty((Object)bucket)) {
                throw new BusinessException((ErrorHandler)I18nError.BUCKET_NAME_NONE);
            }
            if (!this.bucketRepository.existsByName(bucket)) {
                throw new BusinessException((ErrorHandler)I18nError.BUCKET_NONE, new Object[]{bucket});
            }
            List<TenantFileInfoDTO> infoDTOList = entry.getValue();
            if (CollectionUtils.isEmpty(infoDTOList)) {
                throw new BusinessException(String.format("bucket\u5e93[%s]\u4e0b\u79df\u6237\u6587\u4ef6\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a", bucket));
            }
            for (TenantFileInfoDTO infoDTO : infoDTOList) {
                if (ObjectUtils.isEmpty((Object)infoDTO.getTenantId()) && infoDTO.getTenantSid() == null) {
                    throw new BusinessException(String.format("bucket\u5e93[%s]\u4e0b\u79df\u6237sid\u548c\u79df\u6237id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", bucket));
                }
                infoDTO.setBucket(bucket);
            }
            allInfoDTOList.addAll(infoDTOList);
            tenantSids.addAll(infoDTOList.stream().map(TenantFileInfoDTO::getTenantSid).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
    }
}

