/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.storage;

import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.dmc.dao.FileInfoCrudService;
import com.digiwin.dap.middleware.dmc.domain.enumeration.StorageEnum;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.storage.FileStorage;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.lmc.http.utils.IOUtils;
import com.google.common.collect.Range;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class EncryptedFileStorageDecorator
implements FileStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptedFileStorageDecorator.class);
    private static final String FILE_ENCRYPT_METADATA = "ciphertextBlock";
    private final byte[] aesKey;
    private final String bucket;
    private final FileStorage decoratedFileStorage;
    private final FileInfoCrudService fileInfoCrudService;

    public EncryptedFileStorageDecorator(byte[] aesKey, String bucket, FileStorage decoratedFileStorage, FileInfoCrudService fileInfoCrudService) {
        this.aesKey = aesKey;
        this.bucket = bucket;
        this.decoratedFileStorage = decoratedFileStorage;
        this.fileInfoCrudService = fileInfoCrudService;
    }

    public boolean supports(StorageEnum storage) {
        return this.decoratedFileStorage.supports(storage);
    }

    public String getFilePath(FileInfo fileInfo) {
        return this.decoratedFileStorage.getFilePath(fileInfo);
    }

    public void createFile(FileInfo fileInfo) {
        this.decoratedFileStorage.createFile(fileInfo);
    }

    public void uploadFromStream(FileInfo fileInfo, InputStream source) {
        try {
            byte[] ciphertext = AES.encryptIvCBC((byte[])IOUtils.readStreamAsByteArray((InputStream)source), (byte[])this.aesKey);
            this.decoratedFileStorage.uploadFromStream(fileInfo, (InputStream)new ByteArrayInputStream(ciphertext));
            fileInfo.setEncryptFile(true);
            fileInfo.setSize((long)ciphertext.length);
            this.fileInfoCrudService.update((UuIdEntity)fileInfo);
        }
        catch (Exception e) {
            throw new BusinessException("\u6587\u4ef6\u5b58\u50a8\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
        }
    }

    public void uploadFromBytes(FileInfo fileInfo, byte[] source) {
        byte[] ciphertext = AES.encryptIvCBC((byte[])source, (byte[])this.aesKey);
        this.decoratedFileStorage.uploadFromBytes(fileInfo, ciphertext);
        fileInfo.setEncryptFile(true);
        fileInfo.setSize((long)ciphertext.length);
        this.fileInfoCrudService.update((UuIdEntity)fileInfo);
    }

    public void uploadFromStream(FileInfo fileInfo, byte[] source, long from, long to, long total, Integer partNum) {
        if (Objects.isNull(partNum)) {
            this.decoratedFileStorage.uploadFromStream(fileInfo, source, from, to, total, partNum);
            this.fileInfoCrudService.update((UuIdEntity)fileInfo);
            return;
        }
        int plainTextLength = source.length;
        int remainder = plainTextLength % 16 == 0 ? 0 : 16 - plainTextLength % 16;
        int cipherExpansionSize = remainder == 0 ? 32 : remainder + 16;
        byte[] ciphertext = AES.encryptIvCBC((byte[])source, (byte[])this.aesKey);
        long newFrom = from + (long)cipherExpansionSize * (long)(partNum - 1);
        long newTo = to + (long)cipherExpansionSize * (long)partNum.intValue();
        this.decoratedFileStorage.uploadFromStream(fileInfo, ciphertext, newFrom, newTo, total, partNum);
        List ciphertextBlockList = Optional.ofNullable(fileInfo.getMetadata()).map(doc -> doc.get((Object)FILE_ENCRYPT_METADATA)).filter(metadata -> metadata instanceof List).map(metadata -> {
            List list = (List)metadata;
            return list.stream().filter(item -> item instanceof Long).map(item -> (Long)item).collect(Collectors.toList());
        }).orElseGet(ArrayList::new);
        ciphertextBlockList.add(Long.valueOf(ciphertext.length));
        fileInfo.getMetadata().put(FILE_ENCRYPT_METADATA, (Object)ciphertextBlockList);
        if (to == total - 1L) {
            fileInfo.setEncryptFile(true);
            fileInfo.setSize(to);
        }
        this.fileInfoCrudService.update((UuIdEntity)fileInfo);
    }

    public void downloadToStream(FileInfo fileInfo, OutputStream destination) {
        if (!fileInfo.isEncryptFile()) {
            LOGGER.warn("\u5f53\u524dbucket\u3010{}\u3011\u5f00\u542f\u5b58\u50a8\u52a0\u5bc6,\u6587\u4ef6:{}\u4e0d\u662f\u5bc6\u6587\u6587\u4ef6", (Object)this.bucket, (Object)fileInfo.getId());
            this.decoratedFileStorage.downloadToStream(fileInfo, destination);
            return;
        }
        try {
            ByteArrayOutputStream encryptedOutputStream = new ByteArrayOutputStream();
            this.decoratedFileStorage.downloadToStream(fileInfo, (OutputStream)encryptedOutputStream);
            byte[] ciphertext = encryptedOutputStream.toByteArray();
            byte[] plaintext = AES.decryptIvCBC((byte[])ciphertext, (byte[])this.aesKey);
            destination.write(plaintext);
        }
        catch (Exception e) {
            throw new BusinessException("\u5bc6\u6587\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38", (Throwable)e);
        }
    }

    public void downloadPartToStream(FileInfo fileInfo, OutputStream destination, long position, long length) {
        if (!fileInfo.isEncryptFile()) {
            LOGGER.warn("\u5f53\u524dbucket\u3010{}\u3011\u5f00\u542f\u5b58\u50a8\u52a0\u5bc6,\u6587\u4ef6:{}\u4e0d\u662f\u5bc6\u6587\u6587\u4ef6", (Object)this.bucket, (Object)fileInfo.getId());
            this.decoratedFileStorage.downloadToStream(fileInfo, destination);
            return;
        }
        List ciphertextBlockList = Optional.ofNullable(fileInfo.getMetadata()).map(doc -> doc.get((Object)FILE_ENCRYPT_METADATA)).filter(metadata -> metadata instanceof List).map(metadata -> {
            List list = (List)metadata;
            return list.stream().filter(item -> item instanceof Long).map(item -> (Long)item).collect(Collectors.toList());
        }).orElseGet(ArrayList::new);
        if (CollectionUtils.isEmpty((Collection)ciphertextBlockList)) {
            throw new BusinessException("\u5bc6\u6587\u6587\u4ef6\u5206\u6bb5\u4e0b\u8f7d\u5f02\u5e38,\u65e0\u6cd5\u83b7\u53d6\u5bc6\u6587\u5757");
        }
        try {
            long start = 0L;
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (Long ciphertextBlock : ciphertextBlockList) {
                long end = start + ciphertextBlock;
                if (end < fileInfo.getSize()) {
                    ranges.add(Range.closedOpen((Comparable)Long.valueOf(start), (Comparable)Long.valueOf(end)));
                } else {
                    ranges.add(Range.closed((Comparable)Long.valueOf(start), (Comparable)Long.valueOf(end)));
                }
                start = end;
            }
            Optional<Range> startRange = ranges.stream().filter(range -> range.contains((Comparable)Long.valueOf(position))).findFirst();
            Optional<Range> endRange = ranges.stream().filter(range -> range.contains((Comparable)Long.valueOf(position + length))).findFirst();
            if (!startRange.isPresent() || !endRange.isPresent()) {
                throw new BusinessException("\u5bc6\u6587\u6587\u4ef6\u5206\u6bb5\u4e0b\u8f7d\u5f02\u5e38,\u65e0\u6cd5\u83b7\u53d6\u5bc6\u6587\u5757");
            }
            long startIndex = (Long)startRange.get().lowerEndpoint();
            long endIndex = (Long)endRange.get().upperEndpoint();
            long newPosition = startIndex;
            long newLength = endIndex - startIndex;
            ByteArrayOutputStream encryptedOutputStream = new ByteArrayOutputStream();
            this.decoratedFileStorage.downloadPartToStream(fileInfo, (OutputStream)encryptedOutputStream, newPosition, newLength);
            byte[] ciphertext = encryptedOutputStream.toByteArray();
            byte[] plaintext = AES.decryptIvCBC((byte[])ciphertext, (byte[])this.aesKey);
            int remainder = ciphertext.length - plaintext.length;
            int startOffset = (int)(position - (Long)startRange.get().lowerEndpoint());
            int endOffset = (int)((Long)endRange.get().upperEndpoint() - (position + length)) - remainder;
            byte[] newPlaintext = Arrays.copyOfRange(plaintext, startOffset, plaintext.length - endOffset);
            destination.write(newPlaintext);
        }
        catch (Exception e) {
            throw new BusinessException("\u5bc6\u6587\u6587\u4ef6\u5206\u6bb5\u4e0b\u8f7d\u5f02\u5e38", (Throwable)e);
        }
    }

    public byte[] downloadToBytes(FileInfo fileInfo) {
        byte[] ciphertext = this.decoratedFileStorage.downloadToBytes(fileInfo);
        return AES.decryptIvCBC((byte[])ciphertext, (byte[])this.aesKey);
    }

    public void deleteFile(FileInfo fileInfo) {
        this.decoratedFileStorage.deleteFile(fileInfo);
    }

    public long getFileSize(FileInfo fileInfo) {
        return this.decoratedFileStorage.getFileSize(fileInfo);
    }
}

