/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.storage;

import com.digiwin.dap.middleware.dmc.domain.enumeration.StorageEnum;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.util.FileUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public interface FileStorage {
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy/MM");

    public boolean supports(StorageEnum var1);

    default public String getFilePath(FileInfo fileInfo) {
        String datePrefix = LocalDate.now().format(FORMATTER);
        String fileExt = FileUtil.getExtension((String)fileInfo.getFileName());
        String filePath = fileInfo.getBucket() + "/" + datePrefix + "/" + fileInfo.getFileId() + "." + fileExt;
        fileInfo.setFilePath(filePath);
        return fileInfo.getFilePath();
    }

    default public void uploadFromStream(FileInfo fileInfo, InputStream source) {
        throw new UnsupportedOperationException();
    }

    default public void uploadFromBytes(FileInfo fileInfo, byte[] source) {
        throw new UnsupportedOperationException();
    }

    default public void createFile(FileInfo fileInfo) {
        throw new UnsupportedOperationException();
    }

    default public void uploadFromStream(FileInfo fileInfo, byte[] source, long from, long to, long total, Integer partNum) {
        throw new UnsupportedOperationException();
    }

    default public void downloadToStream(FileInfo fileInfo, OutputStream destination) {
        throw new UnsupportedOperationException();
    }

    default public void downloadPartToStream(FileInfo fileInfo, OutputStream destination, long position, long length) {
        throw new UnsupportedOperationException();
    }

    default public byte[] downloadToBytes(FileInfo fileInfo) {
        throw new UnsupportedOperationException();
    }

    default public void deleteFile(FileInfo fileInfo) {
        throw new UnsupportedOperationException();
    }

    default public long getFileSize(FileInfo fileInfo) {
        return fileInfo.getSize();
    }
}

