/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.storage.factory;

import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.dao.FileInfoCrudService;
import com.digiwin.dap.middleware.dmc.domain.enumeration.StorageEnum;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.service.admin.BucketConfigService;
import com.digiwin.dap.middleware.dmc.storage.EncryptedFileStorageDecorator;
import com.digiwin.dap.middleware.dmc.storage.FileStorage;
import com.digiwin.dap.middleware.dmc.storage.FileStorageFactory;
import com.digiwin.dap.middleware.dmc.storage.MongoConfigFactory;
import com.digiwin.dap.middleware.dmc.storage.impl.MongoDbStorage;
import com.digiwin.dap.middleware.dmc.storage.impl.TenantCustomStorage;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class DefaultFileStorageFactory
implements FileStorageFactory {
    private final Map<String, FileStorage> fileStorageCache = new ConcurrentHashMap(128);
    @Qualifier(value="tenantCustomRestTemplate")
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private List<FileStorage> fileStorages;
    @Autowired
    private MongoConfigFactory mongoDbFactory;
    @Autowired
    private BucketConfigService bucketConfigService;
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private FileInfoCrudService fileInfoCrudService;

    public FileStorage selectStorage(String bucket, FileInfo fileInfo) {
        FileStorage fileStorage;
        String tenantId = fileInfo.getTenantId();
        if (fileInfo.getBucket() == null) {
            fileInfo.setBucket(bucket);
        }
        if (fileInfo.getStorage() == null) {
            StorageEnum storage = this.bucketConfigService.getFileStorage(bucket, tenantId);
            fileInfo.setStorage(storage);
        }
        if ((fileStorage = this.getFileStorage(bucket, tenantId, fileInfo.getStorage())) == null) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_STORAGE_NOT_SUPPORT, new Object[]{fileInfo.getStorage()});
        }
        return fileStorage;
    }

    public FileStorage getFileStorage(String bucket, FileInfo fileInfo) {
        if (fileInfo.getStorage() == null) {
            fileInfo.setStorage(StorageEnum.MongoDB);
        }
        return this.getFileStorage(bucket, fileInfo.getTenantId(), fileInfo.getStorage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStorage getFileStorage(String bucket, String tenantId, StorageEnum storage) {
        String storageKey = StorageEnum.MongoDB == storage ? storage.name() + "-" + bucket : (StorageEnum.TenantCustom == storage ? storage.name() + "-" + tenantId : storage.name());
        if (!this.fileStorageCache.containsKey(storageKey)) {
            DefaultFileStorageFactory defaultFileStorageFactory = this;
            synchronized (defaultFileStorageFactory) {
                if (!this.fileStorageCache.containsKey(storageKey)) {
                    if (StorageEnum.MongoDB == storage) {
                        this.fileStorageCache.put(storageKey, new MongoDbStorage(this.mongoDbFactory.getConfiguration(bucket)));
                    } else if (StorageEnum.TenantCustom == storage) {
                        String backUri = this.bucketConfigService.getBackUri(bucket, tenantId);
                        this.fileStorageCache.put(storageKey, new TenantCustomStorage(backUri, this.restTemplate));
                    } else {
                        for (FileStorage fileStorage : this.fileStorages) {
                            if (!fileStorage.supports(storage)) continue;
                            this.fileStorageCache.put(storageKey, fileStorage);
                        }
                    }
                }
            }
        }
        FileStorage fileStorage = (FileStorage)this.fileStorageCache.get(storageKey);
        Bucket bucketInfo = this.bucketRepository.findByName(bucket);
        return Objects.nonNull(bucketInfo) && Objects.nonNull(bucketInfo.isEncryptedStorage()) && bucketInfo.isEncryptedStorage() != false ? new EncryptedFileStorageDecorator(Base64.decode((String)bucketInfo.getAesKey()), bucket, fileStorage, this.fileInfoCrudService) : fileStorage;
    }
}

