/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.storage.gridfs;

import com.digiwin.dap.middleware.dmc.storage.gridfs.DmcGridFSDownloadStream;
import com.digiwin.dap.middleware.dmc.storage.gridfs.DmcGridFSFindIterable;
import com.digiwin.dap.middleware.dmc.storage.gridfs.DmcGridFSUploadStream;
import com.digiwin.dap.middleware.dmc.storage.gridfs.client.GridFSBucketImpl;
import com.mongodb.MongoGridFSException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.lang.Nullable;
import java.io.IOException;
import java.io.InputStream;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;

public final class DmcGridFSBucket
extends GridFSBucketImpl {
    DmcGridFSBucket(MongoDatabase database) {
        super(database, "fs");
    }

    DmcGridFSBucket(MongoDatabase database, String bucketName) {
        super(database, bucketName);
    }

    DmcGridFSBucket(String bucketName, int chunkSizeBytes, MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection) {
        super(bucketName, chunkSizeBytes, filesCollection, chunksCollection);
    }

    public GridFSBucket withChunkSizeBytes(int chunkSizeBytes) {
        return new DmcGridFSBucket(this.bucketName, chunkSizeBytes, this.filesCollection, this.chunksCollection);
    }

    public GridFSBucket withReadPreference(ReadPreference readPreference) {
        return new DmcGridFSBucket(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadPreference(readPreference), this.chunksCollection.withReadPreference(readPreference));
    }

    public GridFSBucket withWriteConcern(WriteConcern writeConcern) {
        return new DmcGridFSBucket(this.bucketName, this.chunkSizeBytes, this.filesCollection.withWriteConcern(writeConcern), this.chunksCollection.withWriteConcern(writeConcern));
    }

    public GridFSBucket withReadConcern(ReadConcern readConcern) {
        return new DmcGridFSBucket(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadConcern(readConcern), this.chunksCollection.withReadConcern(readConcern));
    }

    protected GridFSDownloadStream createGridFSDownloadStream(@Nullable ClientSession clientSession, GridFSFile gridFSFile) {
        return new DmcGridFSDownloadStream(clientSession, gridFSFile, this.chunksCollection);
    }

    protected GridFSFindIterable createGridFSFindIterable(@Nullable ClientSession clientSession, @Nullable Bson filter) {
        return new DmcGridFSFindIterable(this.createFindIterable(clientSession, filter));
    }

    protected DmcGridFSUploadStream createGridFSUploadStream(@Nullable ClientSession clientSession, BsonValue id, String filename, GridFSUploadOptions options) {
        Assertions.notNull((String)"options", (Object)options);
        Integer chunkSizeBytes = options.getChunkSizeBytes();
        int chunkSize = chunkSizeBytes == null ? this.chunkSizeBytes : chunkSizeBytes;
        this.checkCreateIndex(clientSession);
        GridFSFile fileInfo = (GridFSFile)this.createFindIterable(clientSession, Filters.eq((String)"_id", (Object)id)).first();
        if (fileInfo != null) {
            return new DmcGridFSUploadStream(clientSession, this.filesCollection, this.chunksCollection, fileInfo, chunkSize);
        }
        return new DmcGridFSUploadStream(clientSession, this.filesCollection, this.chunksCollection, id, filename, chunkSize, options.getMetadata());
    }

    protected void executeUploadFromStream(@Nullable ClientSession clientSession, BsonValue id, String filename, InputStream source, GridFSUploadOptions options) {
        DmcGridFSUploadStream uploadStream = this.createGridFSUploadStream(clientSession, id, filename, options);
        Integer chunkSizeBytes = options.getChunkSizeBytes();
        int chunkSize = chunkSizeBytes == null ? this.chunkSizeBytes : chunkSizeBytes;
        byte[] buffer = new byte[chunkSize];
        try {
            int len;
            uploadStream.skipToLast();
            while ((len = source.read(buffer)) != -1) {
                uploadStream.write(buffer, 0, len);
            }
            uploadStream.close();
        }
        catch (IOException e) {
            uploadStream.abort();
            throw new MongoGridFSException("IOException when reading from the InputStream", (Throwable)e);
        }
    }
}

