/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.storage.gridfs;

import com.digiwin.dap.middleware.dmc.storage.gridfs.client.GridFSUploadStreamImpl;
import com.mongodb.MongoGridFSException;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.Updates;
import com.mongodb.lang.Nullable;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bson.types.ObjectId;

final class DmcGridFSUploadStream
extends GridFSUploadStreamImpl {
    private GridFSFile existedFileInfo;
    private ObjectId chunkId;
    private boolean chunkIsNew = true;

    DmcGridFSUploadStream(@Nullable ClientSession clientSession, MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection, BsonValue fileId, String filename, int chunkSizeBytes, @Nullable Document metadata) {
        super(clientSession, filesCollection, chunksCollection, fileId, filename, chunkSizeBytes, metadata);
    }

    DmcGridFSUploadStream(@Nullable ClientSession clientSession, MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection, GridFSFile fileInfo, int chunkSizeBytes) {
        super(clientSession, filesCollection, chunksCollection, fileInfo.getId(), fileInfo.getFilename(), chunkSizeBytes, fileInfo.getMetadata());
        this.lengthInBytes = fileInfo.getLength();
        this.existedFileInfo = fileInfo;
    }

    public void close(GridFSFile gridFSFile) {
        if (this.existedFileInfo != null) {
            Bson condition = Filters.eq((String)"_id", (Object)this.fileId);
            if (this.clientSession != null) {
                this.filesCollection.replaceOne(this.clientSession, condition, (Object)gridFSFile);
            } else {
                this.filesCollection.replaceOne(condition, (Object)gridFSFile);
            }
        } else {
            super.close(gridFSFile);
        }
    }

    protected void writeChunk() {
        if (this.bufferOffset > 0) {
            if (!this.chunkIsNew && this.chunkId != null) {
                Bson condition = Filters.eq((String)"_id", (Object)new BsonObjectId(this.chunkId));
                if (this.clientSession == null) {
                    this.chunksCollection.updateOne(condition, Updates.combine((Bson[])new Bson[]{Updates.set((String)"files_id", (Object)this.fileId), Updates.set((String)"n", (Object)this.chunkIndex), Updates.set((String)"data", (Object)this.getData())}));
                } else {
                    this.chunksCollection.updateOne(this.clientSession, condition, Updates.combine((Bson[])new Bson[]{Updates.set((String)"files_id", (Object)this.fileId), Updates.set((String)"n", (Object)this.chunkIndex), Updates.set((String)"data", (Object)this.getData())}));
                }
                ++this.chunkIndex;
                this.bufferOffset = 0;
                this.chunkIsNew = true;
                this.chunkId = null;
            } else {
                super.writeChunk();
            }
        }
    }

    void skipToLast() {
        if (this.existedFileInfo == null) {
            return;
        }
        Bson condition = Filters.eq((String)"files_id", (Object)this.fileId);
        Document lastChunkDocument = (Document)this.chunksCollection.find(condition).sort(Sorts.descending((String[])new String[]{"n"})).first();
        if (lastChunkDocument != null) {
            this.chunkIndex = Integer.parseInt(lastChunkDocument.get((Object)"n").toString());
            byte[] data = this.getBufferFromChunk(lastChunkDocument);
            if (data.length == this.chunkSizeBytes) {
                this.bufferOffset = 0;
                ++this.chunkIndex;
                this.chunkIsNew = true;
                this.chunkId = null;
            } else {
                this.bufferOffset = data.length;
                System.arraycopy(data, 0, this.buffer, 0, data.length);
                this.chunkIsNew = false;
                this.chunkId = lastChunkDocument.getObjectId((Object)"_id");
            }
        }
    }

    private byte[] getBufferFromChunk(@Nullable Document chunk) {
        if (!(chunk.get((Object)"data") instanceof Binary)) {
            throw new MongoGridFSException("Unexpected data format for the chunk");
        }
        return ((Binary)chunk.get((Object)"data", Binary.class)).getData();
    }
}

