/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.storage.gridfs;

import com.digiwin.dap.middleware.dmc.storage.gridfs.DmcGridFSBucket;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;

public class MongoConfiguration {
    private final MongoClient mongoClient;
    private final String bucket;
    private MongoDatabase mongoDatabase;
    private GridFSBucket gridFSBucket;

    public MongoConfiguration(MongoClient mongoClient, String bucket) {
        this.bucket = bucket;
        this.mongoClient = mongoClient;
    }

    public String getBucket() {
        return this.bucket;
    }

    public MongoDatabase getMongoDatabase() {
        if (this.mongoDatabase == null) {
            this.mongoDatabase = this.mongoClient.getDatabase(this.bucket);
            CodecRegistry pojoCodecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{PojoCodecProvider.builder().automatic(true).build()})});
            this.mongoDatabase = this.mongoDatabase.withCodecRegistry(pojoCodecRegistry);
        }
        return this.mongoDatabase;
    }

    public GridFSBucket getGridFSBucket() {
        if (this.gridFSBucket == null) {
            this.gridFSBucket = new DmcGridFSBucket(this.getMongoDatabase(), this.bucket);
        }
        return this.gridFSBucket;
    }
}

