/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.storage.gridfs.client;

import com.digiwin.dap.middleware.dmc.storage.gridfs.client.GridFSDownloadStreamImpl;
import com.digiwin.dap.middleware.dmc.storage.gridfs.client.GridFSFindIterableImpl;
import com.digiwin.dap.middleware.dmc.storage.gridfs.client.GridFSUploadStreamImpl;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoGridFSException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.GridFSUploadStream;
import com.mongodb.client.gridfs.model.GridFSDownloadOptions;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.lang.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

/*
 * Exception performing whole class analysis ignored.
 */
public class GridFSBucketImpl
implements GridFSBucket {
    protected static final int DEFAULT_CHUNKSIZE_BYTES = 261120;
    protected final String bucketName;
    protected final int chunkSizeBytes;
    protected final MongoCollection<GridFSFile> filesCollection;
    protected final MongoCollection<Document> chunksCollection;
    private volatile boolean checkedIndexes;

    protected GridFSBucketImpl(MongoDatabase database) {
        this(database, "fs");
    }

    protected GridFSBucketImpl(MongoDatabase database, String bucketName) {
        this((String)Assertions.notNull((String)"bucketName", (Object)bucketName), 261120, GridFSBucketImpl.getFilesCollection((MongoDatabase)((MongoDatabase)Assertions.notNull((String)"database", (Object)database)), (String)bucketName), GridFSBucketImpl.getChunksCollection((MongoDatabase)database, (String)bucketName));
    }

    protected GridFSBucketImpl(String bucketName, int chunkSizeBytes, MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection) {
        this.bucketName = (String)Assertions.notNull((String)"bucketName", (Object)bucketName);
        this.chunkSizeBytes = chunkSizeBytes;
        this.filesCollection = (MongoCollection)Assertions.notNull((String)"filesCollection", filesCollection);
        this.chunksCollection = (MongoCollection)Assertions.notNull((String)"chunksCollection", chunksCollection);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public int getChunkSizeBytes() {
        return this.chunkSizeBytes;
    }

    public ReadPreference getReadPreference() {
        return this.filesCollection.getReadPreference();
    }

    public WriteConcern getWriteConcern() {
        return this.filesCollection.getWriteConcern();
    }

    public ReadConcern getReadConcern() {
        return this.filesCollection.getReadConcern();
    }

    public GridFSBucket withChunkSizeBytes(int chunkSizeBytes) {
        return new GridFSBucketImpl(this.bucketName, chunkSizeBytes, this.filesCollection, this.chunksCollection);
    }

    public GridFSBucket withReadPreference(ReadPreference readPreference) {
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadPreference(readPreference), this.chunksCollection.withReadPreference(readPreference));
    }

    public GridFSBucket withWriteConcern(WriteConcern writeConcern) {
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withWriteConcern(writeConcern), this.chunksCollection.withWriteConcern(writeConcern));
    }

    public GridFSBucket withReadConcern(ReadConcern readConcern) {
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadConcern(readConcern), this.chunksCollection.withReadConcern(readConcern));
    }

    public GridFSUploadStream openUploadStream(String filename) {
        return this.openUploadStream((BsonValue)new BsonObjectId(), filename);
    }

    public GridFSUploadStream openUploadStream(String filename, GridFSUploadOptions options) {
        return this.openUploadStream((BsonValue)new BsonObjectId(), filename, options);
    }

    public GridFSUploadStream openUploadStream(BsonValue id, String filename) {
        return this.openUploadStream(id, filename, new GridFSUploadOptions());
    }

    public GridFSUploadStream openUploadStream(BsonValue id, String filename, GridFSUploadOptions options) {
        return this.createGridFSUploadStream(null, id, filename, options);
    }

    public GridFSUploadStream openUploadStream(ClientSession clientSession, String filename) {
        return this.openUploadStream(clientSession, (BsonValue)new BsonObjectId(), filename);
    }

    public GridFSUploadStream openUploadStream(ClientSession clientSession, String filename, GridFSUploadOptions options) {
        return this.openUploadStream(clientSession, (BsonValue)new BsonObjectId(), filename, options);
    }

    public GridFSUploadStream openUploadStream(ClientSession clientSession, ObjectId id, String filename) {
        return this.openUploadStream(clientSession, (BsonValue)new BsonObjectId(id), filename);
    }

    public GridFSUploadStream openUploadStream(ClientSession clientSession, BsonValue id, String filename) {
        return this.openUploadStream(clientSession, id, filename, new GridFSUploadOptions());
    }

    public GridFSUploadStream openUploadStream(ClientSession clientSession, BsonValue id, String filename, GridFSUploadOptions options) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createGridFSUploadStream(clientSession, id, filename, options);
    }

    protected GridFSUploadStream createGridFSUploadStream(@Nullable ClientSession clientSession, BsonValue id, String filename, GridFSUploadOptions options) {
        Assertions.notNull((String)"options", (Object)options);
        Integer chunkSizeBytes = options.getChunkSizeBytes();
        int chunkSize = chunkSizeBytes == null ? this.chunkSizeBytes : chunkSizeBytes;
        this.checkCreateIndex(clientSession);
        return new GridFSUploadStreamImpl(clientSession, this.filesCollection, this.chunksCollection, id, filename, chunkSize, options.getMetadata());
    }

    public ObjectId uploadFromStream(String filename, InputStream source) {
        return this.uploadFromStream(filename, source, new GridFSUploadOptions());
    }

    public ObjectId uploadFromStream(String filename, InputStream source, GridFSUploadOptions options) {
        ObjectId id = new ObjectId();
        this.uploadFromStream((BsonValue)new BsonObjectId(id), filename, source, options);
        return id;
    }

    public void uploadFromStream(BsonValue id, String filename, InputStream source) {
        this.uploadFromStream(id, filename, source, new GridFSUploadOptions());
    }

    public void uploadFromStream(BsonValue id, String filename, InputStream source, GridFSUploadOptions options) {
        this.executeUploadFromStream(null, id, filename, source, options);
    }

    public ObjectId uploadFromStream(ClientSession clientSession, String filename, InputStream source) {
        return this.uploadFromStream(clientSession, filename, source, new GridFSUploadOptions());
    }

    public ObjectId uploadFromStream(ClientSession clientSession, String filename, InputStream source, GridFSUploadOptions options) {
        ObjectId id = new ObjectId();
        this.uploadFromStream(clientSession, (BsonValue)new BsonObjectId(id), filename, source, options);
        return id;
    }

    public void uploadFromStream(ClientSession clientSession, BsonValue id, String filename, InputStream source) {
        this.uploadFromStream(clientSession, id, filename, source, new GridFSUploadOptions());
    }

    public void uploadFromStream(ClientSession clientSession, BsonValue id, String filename, InputStream source, GridFSUploadOptions options) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeUploadFromStream(clientSession, id, filename, source, options);
    }

    protected void executeUploadFromStream(@Nullable ClientSession clientSession, BsonValue id, String filename, InputStream source, GridFSUploadOptions options) {
        GridFSUploadStream uploadStream = this.createGridFSUploadStream(clientSession, id, filename, options);
        Integer chunkSizeBytes = options.getChunkSizeBytes();
        int chunkSize = chunkSizeBytes == null ? this.chunkSizeBytes : chunkSizeBytes;
        byte[] buffer = new byte[chunkSize];
        try {
            int len;
            while ((len = source.read(buffer)) != -1) {
                uploadStream.write(buffer, 0, len);
            }
            uploadStream.close();
        }
        catch (IOException e) {
            uploadStream.abort();
            throw new MongoGridFSException("IOException when reading from the InputStream", (Throwable)e);
        }
    }

    public GridFSDownloadStream openDownloadStream(ObjectId id) {
        return this.openDownloadStream((BsonValue)new BsonObjectId(id));
    }

    public GridFSDownloadStream openDownloadStream(BsonValue id) {
        return this.createGridFSDownloadStream(null, this.getFileInfoById(null, id));
    }

    public GridFSDownloadStream openDownloadStream(String filename) {
        return this.openDownloadStream(filename, new GridFSDownloadOptions());
    }

    public GridFSDownloadStream openDownloadStream(String filename, GridFSDownloadOptions options) {
        return this.createGridFSDownloadStream(null, this.getFileByName(null, filename, options));
    }

    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, ObjectId id) {
        return this.openDownloadStream(clientSession, (BsonValue)new BsonObjectId(id));
    }

    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, BsonValue id) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createGridFSDownloadStream(clientSession, this.getFileInfoById(clientSession, id));
    }

    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, String filename) {
        return this.openDownloadStream(clientSession, filename, new GridFSDownloadOptions());
    }

    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, String filename, GridFSDownloadOptions options) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createGridFSDownloadStream(clientSession, this.getFileByName(clientSession, filename, options));
    }

    protected GridFSDownloadStream createGridFSDownloadStream(@Nullable ClientSession clientSession, GridFSFile gridFSFile) {
        return new GridFSDownloadStreamImpl(clientSession, gridFSFile, this.chunksCollection);
    }

    public void downloadToStream(ObjectId id, OutputStream destination) {
        this.downloadToStream((BsonValue)new BsonObjectId(id), destination);
    }

    public void downloadToStream(BsonValue id, OutputStream destination) {
        this.downloadToStream(this.openDownloadStream(id), destination);
    }

    public void downloadToStream(String filename, OutputStream destination) {
        this.downloadToStream(filename, destination, new GridFSDownloadOptions());
    }

    public void downloadToStream(String filename, OutputStream destination, GridFSDownloadOptions options) {
        this.downloadToStream(this.openDownloadStream(filename, options), destination);
    }

    public void downloadToStream(ClientSession clientSession, ObjectId id, OutputStream destination) {
        this.downloadToStream(clientSession, (BsonValue)new BsonObjectId(id), destination);
    }

    public void downloadToStream(ClientSession clientSession, BsonValue id, OutputStream destination) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.downloadToStream(this.openDownloadStream(clientSession, id), destination);
    }

    public void downloadToStream(ClientSession clientSession, String filename, OutputStream destination) {
        this.downloadToStream(clientSession, filename, destination, new GridFSDownloadOptions());
    }

    public void downloadToStream(ClientSession clientSession, String filename, OutputStream destination, GridFSDownloadOptions options) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.downloadToStream(this.openDownloadStream(clientSession, filename, options), destination);
    }

    public GridFSFindIterable find() {
        return this.createGridFSFindIterable(null, null);
    }

    public GridFSFindIterable find(Bson filter) {
        Assertions.notNull((String)"filter", (Object)filter);
        return this.createGridFSFindIterable(null, filter);
    }

    public GridFSFindIterable find(ClientSession clientSession) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createGridFSFindIterable(clientSession, null);
    }

    public GridFSFindIterable find(ClientSession clientSession, Bson filter) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        Assertions.notNull((String)"filter", (Object)filter);
        return this.createGridFSFindIterable(clientSession, filter);
    }

    protected GridFSFindIterable createGridFSFindIterable(@Nullable ClientSession clientSession, @Nullable Bson filter) {
        return new GridFSFindIterableImpl(this.createFindIterable(clientSession, filter));
    }

    public void delete(ObjectId id) {
        this.delete((BsonValue)new BsonObjectId(id));
    }

    public void delete(BsonValue id) {
        this.executeDelete(null, id);
    }

    public void delete(ClientSession clientSession, ObjectId id) {
        this.delete(clientSession, (BsonValue)new BsonObjectId(id));
    }

    public void delete(ClientSession clientSession, BsonValue id) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeDelete(clientSession, id);
    }

    private void executeDelete(@Nullable ClientSession clientSession, BsonValue id) {
        DeleteResult result;
        if (clientSession != null) {
            result = this.filesCollection.deleteOne(clientSession, (Bson)new BsonDocument("_id", id));
            this.chunksCollection.deleteMany(clientSession, (Bson)new BsonDocument("files_id", id));
        } else {
            result = this.filesCollection.deleteOne((Bson)new BsonDocument("_id", id));
            this.chunksCollection.deleteMany((Bson)new BsonDocument("files_id", id));
        }
        if (result.wasAcknowledged() && result.getDeletedCount() == 0L) {
            System.out.printf("No file found with the id: %s", id);
        }
    }

    public void rename(ObjectId id, String newFilename) {
        this.rename((BsonValue)new BsonObjectId(id), newFilename);
    }

    public void rename(BsonValue id, String newFilename) {
        this.executeRename(null, id, newFilename);
    }

    public void rename(ClientSession clientSession, ObjectId id, String newFilename) {
        this.rename(clientSession, (BsonValue)new BsonObjectId(id), newFilename);
    }

    public void rename(ClientSession clientSession, BsonValue id, String newFilename) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeRename(clientSession, id, newFilename);
    }

    private void executeRename(@Nullable ClientSession clientSession, BsonValue id, String newFilename) {
        UpdateResult updateResult = clientSession != null ? this.filesCollection.updateOne(clientSession, (Bson)new BsonDocument("_id", id), (Bson)new BsonDocument("$set", (BsonValue)new BsonDocument("filename", (BsonValue)new BsonString(newFilename)))) : this.filesCollection.updateOne((Bson)new BsonDocument("_id", id), (Bson)new BsonDocument("$set", (BsonValue)new BsonDocument("filename", (BsonValue)new BsonString(newFilename))));
        if (updateResult.wasAcknowledged() && updateResult.getMatchedCount() == 0L) {
            throw new MongoGridFSException(String.format("No file found with the id: %s", id));
        }
    }

    public void drop() {
        this.filesCollection.drop();
        this.chunksCollection.drop();
    }

    public void drop(ClientSession clientSession) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.filesCollection.drop(clientSession);
        this.chunksCollection.drop(clientSession);
    }

    private static MongoCollection<GridFSFile> getFilesCollection(MongoDatabase database, String bucketName) {
        return database.getCollection(bucketName + ".files", GridFSFile.class).withCodecRegistry(CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{database.getCodecRegistry(), MongoClientSettings.getDefaultCodecRegistry()}));
    }

    private static MongoCollection<Document> getChunksCollection(MongoDatabase database, String bucketName) {
        return database.getCollection(bucketName + ".chunks").withCodecRegistry(MongoClientSettings.getDefaultCodecRegistry());
    }

    protected void checkCreateIndex(@Nullable ClientSession clientSession) {
        if (!this.checkedIndexes) {
            if (this.collectionIsEmpty(clientSession, this.filesCollection.withDocumentClass(Document.class).withReadPreference(ReadPreference.primary()))) {
                Document filesIndex = new Document("filename", (Object)1).append("uploadDate", (Object)1);
                if (!this.hasIndex(clientSession, this.filesCollection.withReadPreference(ReadPreference.primary()), filesIndex)) {
                    this.createIndex(clientSession, this.filesCollection, filesIndex, new IndexOptions());
                }
                Document chunksIndex = new Document("files_id", (Object)1).append("n", (Object)1);
                if (!this.hasIndex(clientSession, this.chunksCollection.withReadPreference(ReadPreference.primary()), chunksIndex)) {
                    this.createIndex(clientSession, this.chunksCollection, chunksIndex, new IndexOptions().unique(true));
                }
            }
            this.checkedIndexes = true;
        }
    }

    private <T> boolean collectionIsEmpty(@Nullable ClientSession clientSession, MongoCollection<T> collection) {
        if (clientSession != null) {
            return collection.find(clientSession).projection((Bson)new Document("_id", (Object)1)).first() == null;
        }
        return collection.find().projection((Bson)new Document("_id", (Object)1)).first() == null;
    }

    private <T> boolean hasIndex(@Nullable ClientSession clientSession, MongoCollection<T> collection, Document index) {
        boolean hasIndex = false;
        ListIndexesIterable listIndexesIterable = clientSession != null ? collection.listIndexes(clientSession) : collection.listIndexes();
        ArrayList indexes = (ArrayList)listIndexesIterable.into(new ArrayList());
        for (Document result : indexes) {
            Document indexDoc = (Document)result.get((Object)"key", (Object)new Document());
            for (Map.Entry entry : indexDoc.entrySet()) {
                if (!(entry.getValue() instanceof Number)) continue;
                entry.setValue(((Number)entry.getValue()).intValue());
            }
            if (!indexDoc.equals((Object)index)) continue;
            hasIndex = true;
            break;
        }
        return hasIndex;
    }

    private <T> void createIndex(@Nullable ClientSession clientSession, MongoCollection<T> collection, Document index, IndexOptions indexOptions) {
        if (clientSession != null) {
            collection.createIndex(clientSession, (Bson)index, indexOptions);
        } else {
            collection.createIndex((Bson)index, indexOptions);
        }
    }

    private GridFSFile getFileByName(@Nullable ClientSession clientSession, String filename, GridFSDownloadOptions options) {
        int sort;
        int skip;
        int revision = options.getRevision();
        if (revision >= 0) {
            skip = revision;
            sort = 1;
        } else {
            skip = -revision - 1;
            sort = -1;
        }
        GridFSFile fileInfo = (GridFSFile)this.createGridFSFindIterable(clientSession, (Bson)new Document("filename", (Object)filename)).skip(skip).sort((Bson)new Document("uploadDate", (Object)sort)).first();
        if (fileInfo == null) {
            throw new MongoGridFSException(String.format("No file found with the filename: %s and revision: %s", filename, revision));
        }
        return fileInfo;
    }

    private GridFSFile getFileInfoById(@Nullable ClientSession clientSession, BsonValue id) {
        Assertions.notNull((String)"id", (Object)id);
        GridFSFile fileInfo = (GridFSFile)this.createFindIterable(clientSession, (Bson)new Document("_id", (Object)id)).first();
        if (fileInfo == null) {
            throw new MongoGridFSException(String.format("No file found with the id: %s", id));
        }
        return fileInfo;
    }

    protected FindIterable<GridFSFile> createFindIterable(@Nullable ClientSession clientSession, @Nullable Bson filter) {
        FindIterable findIterable = clientSession != null ? this.filesCollection.find(clientSession) : this.filesCollection.find();
        if (filter != null) {
            findIterable = findIterable.filter(filter);
        }
        return findIterable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadToStream(GridFSDownloadStream downloadStream, OutputStream destination) {
        block16: {
            byte[] buffer = new byte[downloadStream.getGridFSFile().getChunkSize()];
            MongoGridFSException savedThrowable = null;
            try {
                int len;
                while ((len = downloadStream.read(buffer)) != -1) {
                    destination.write(buffer, 0, len);
                }
            }
            catch (IOException e) {
                savedThrowable = new MongoGridFSException("IOException when reading from the OutputStream", (Throwable)e);
            }
            catch (Exception e) {
                savedThrowable = new MongoGridFSException("Unexpected Exception when reading GridFS and writing to the Stream", (Throwable)e);
            }
            finally {
                try {
                    downloadStream.close();
                }
                catch (Exception e) {}
                if (savedThrowable == null) break block16;
                throw savedThrowable;
            }
        }
    }
}

