/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.storage.impl;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.AppendObjectRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.PutObjectRequest;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.StorageEnum;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.storage.FileStorage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.springframework.util.StreamUtils;

@Service
@ConditionalOnExpression(value="#{T(org.springframework.util.StringUtils).hasLength(environment.getProperty('dap.middleware.storage.aliyun.endpoint'))}")
public class AliyunFileStorage
implements FileStorage,
InitializingBean {
    private OSS ossClient;
    private String bucket;
    @Autowired
    private EnvProperties env;

    public boolean supports(StorageEnum storage) {
        return StorageEnum.OSS == storage;
    }

    public void uploadFromStream(FileInfo fileInfo, InputStream source) {
        if (fileInfo.getSize() > 0L) {
            this.uploadOssFromStream(fileInfo, source);
        } else {
            try {
                byte[] bytes = StreamUtils.copyToByteArray((InputStream)source);
                this.uploadFromBytes(fileInfo, bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void uploadFromBytes(FileInfo fileInfo, byte[] source) {
        fileInfo.setSize((long)source.length);
        this.uploadOssFromStream(fileInfo, (InputStream)new ByteArrayInputStream(source));
    }

    private void uploadOssFromStream(FileInfo fileInfo, InputStream source) {
        if (fileInfo.getFileId() == null) {
            fileInfo.setFileId(ObjectId.get());
        }
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, this.getFilePath(fileInfo), source);
        this.ossClient.putObject(putObjectRequest);
    }

    public void createFile(FileInfo fileInfo) {
        fileInfo.setFileId(new ObjectId());
    }

    public void uploadFromStream(FileInfo fileInfo, byte[] source, long from, long to, long total, Integer partNum) {
        if (fileInfo.getFileId() == null) {
            fileInfo.setFileId(ObjectId.get());
        }
        AppendObjectRequest appendObjectRequest = new AppendObjectRequest(this.bucket, this.getFilePath(fileInfo), (InputStream)new ByteArrayInputStream(source));
        appendObjectRequest.setPosition(Long.valueOf(from));
        this.ossClient.appendObject(appendObjectRequest);
    }

    public void downloadToStream(FileInfo fileInfo, OutputStream destination) {
        OSSObject ossObject = this.ossClient.getObject(this.bucket, fileInfo.getFilePath());
        try {
            StreamUtils.copy((InputStream)ossObject.getObjectContent(), (OutputStream)destination);
            ossObject.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void downloadPartToStream(FileInfo fileInfo, OutputStream destination, long position, long length) {
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucket, fileInfo.getFilePath());
        getObjectRequest.setRange(position, position + length - 1L);
        OSSObject ossObject = this.ossClient.getObject(getObjectRequest);
        try {
            StreamUtils.copy((InputStream)ossObject.getObjectContent(), (OutputStream)destination);
            ossObject.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] downloadToBytes(FileInfo fileInfo) {
        OSSObject ossObject = this.ossClient.getObject(this.bucket, fileInfo.getFilePath());
        try {
            byte[] bytes = StreamUtils.copyToByteArray((InputStream)ossObject.getObjectContent());
            ossObject.close();
            return bytes;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteFile(FileInfo fileInfo) {
        this.ossClient.deleteObject(this.bucket, fileInfo.getFilePath());
    }

    public void afterPropertiesSet() throws Exception {
        this.bucket = this.env.getAliyunBucket();
        this.ossClient = new OSSClientBuilder().build(this.env.getAliyunEndpoint(), this.env.getAliyunAccessKeyId(), this.env.getAliyunAccessKeySecret());
    }
}

