/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.storage.impl;

import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.options.BlobInputStreamOptions;
import com.azure.storage.blob.specialized.BlobInputStream;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.digiwin.dap.middleware.dmc.dao.FileInfoCrudService;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.StorageEnum;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.storage.FileStorage;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.UUID;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.springframework.util.StreamUtils;

@Service
@ConditionalOnExpression(value="#{T(org.springframework.util.StringUtils).hasLength(environment.getProperty('dap.middleware.storage.azure.account.connection'))}")
public class AzureFileStorage
implements FileStorage,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AzureFileStorage.class);
    private static final String BLOB_SERVICE_CLIENT_BUILDER_ENDPOINT = "https://%s.blob.core.windows.net/";
    private BlobContainerClient blobContainerClient;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private FileInfoCrudService fileInfoCrudService;

    public boolean supports(StorageEnum storage) {
        return StorageEnum.ABS == storage;
    }

    public void uploadFromStream(FileInfo fileInfo, InputStream source) {
        if (fileInfo.getFileId() == null) {
            fileInfo.setFileId(ObjectId.get());
        }
        BlockBlobClient blobClient = this.blobContainerClient.getBlobClient(this.getFilePath(fileInfo)).getBlockBlobClient();
        ByteArrayInputStream inputStream = null;
        try {
            byte[] bytes = StreamUtils.copyToByteArray((InputStream)source);
            fileInfo.setSize((long)bytes.length);
            inputStream = new ByteArrayInputStream(bytes);
            blobClient.upload((InputStream)inputStream, (long)bytes.length);
        }
        catch (IOException e) {
            throw new BusinessException("AzureFileStorage-uploadFromStream", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new BusinessException("AzureFileStorage-uploadFromBytes", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFromBytes(FileInfo fileInfo, byte[] source) {
        if (fileInfo.getFileId() == null) {
            fileInfo.setFileId(ObjectId.get());
        }
        fileInfo.setSize((long)source.length);
        InputStream inputStream = null;
        try {
            BlockBlobClient blobClient = this.blobContainerClient.getBlobClient(this.getFilePath(fileInfo)).getBlockBlobClient();
            inputStream = new ByteArrayInputStream(source);
            blobClient.upload(inputStream, (long)source.length);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new BusinessException("AzureFileStorage-uploadFromBytes", (Throwable)e);
                }
            }
        }
    }

    public void createFile(FileInfo fileInfo) {
        fileInfo.setFileId(new ObjectId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFromStream(FileInfo fileInfo, byte[] source, long from, long to, long total, Integer partNum) {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            Document metadata = fileInfo.getMetadata();
            String key = fileInfo.getFileId().toString();
            Object o = metadata.get((Object)key);
            ArrayList<String> blockIds = null;
            blockIds = o == null ? new ArrayList<String>() : (ArrayList<String>)o;
            BlockBlobClient blobClient = this.blobContainerClient.getBlobClient(this.getFilePath(fileInfo)).getBlockBlobClient();
            byteArrayInputStream = new ByteArrayInputStream(source);
            String blockID = Base64.getEncoder().encodeToString(UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8));
            blobClient.stageBlock(blockID, (InputStream)byteArrayInputStream, (long)byteArrayInputStream.available());
            blockIds.add(blockID);
            if (to == total - 1L) {
                blobClient.commitBlockList(blockIds);
                metadata.remove((Object)key);
            } else {
                metadata.append(key, blockIds);
            }
            this.fileInfoCrudService.update((UuIdEntity)fileInfo);
        }
        finally {
            try {
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
            }
            catch (IOException e) {
                throw new BusinessException("AzureFileStorage-uploadFromStream", (Throwable)e);
            }
        }
    }

    public void downloadToStream(FileInfo fileInfo, OutputStream destination) {
        BlockBlobClient blobClient = this.blobContainerClient.getBlobClient(fileInfo.getFilePath()).getBlockBlobClient();
        blobClient.downloadStream(destination);
        try {
            destination.flush();
        }
        catch (IOException e) {
            throw new BusinessException("AzureFileStorage-downloadToStream", (Throwable)e);
        }
    }

    public void downloadPartToStream(FileInfo fileInfo, OutputStream destination, long position, long length) {
        try (BlobInputStream blobInputStream = null;){
            BlockBlobClient blobClient = this.blobContainerClient.getBlobClient(fileInfo.getFilePath()).getBlockBlobClient();
            BlobRange range = new BlobRange(position, Long.valueOf(length));
            BlobInputStreamOptions blobInputStreamOptions = new BlobInputStreamOptions().setRange(range);
            blobInputStream = blobClient.openInputStream(blobInputStreamOptions);
            byte[] bytes = new byte[(int)length];
            blobInputStream.read(bytes);
            destination.write(bytes);
            destination.flush();
        }
    }

    public byte[] downloadToBytes(FileInfo fileInfo) {
        BlockBlobClient blobClient = this.blobContainerClient.getBlobClient(fileInfo.getFilePath()).getBlockBlobClient();
        return blobClient.downloadContent().toBytes();
    }

    public void deleteFile(FileInfo fileInfo) {
        BlockBlobClient blobClient = this.blobContainerClient.getBlobClient(fileInfo.getFilePath()).getBlockBlobClient();
        blobClient.delete();
    }

    public void afterPropertiesSet() throws Exception {
        try {
            BlobServiceClient blobServiceClient = new BlobServiceClientBuilder().endpoint(String.format(BLOB_SERVICE_CLIENT_BUILDER_ENDPOINT, this.envProperties.getAzureAccountName())).connectionString(this.envProperties.getAzureConnection()).buildClient();
            this.blobContainerClient = blobServiceClient.getBlobContainerClient(this.envProperties.getAzureContainer());
            this.blobContainerClient.createIfNotExists();
        }
        catch (Exception e) {
            logger.error("\u3010afterPropertiesSet\u3011{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

