/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.storage.impl;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.domain.enumeration.StorageEnum;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.storage.FileStorage;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StreamUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class FileSystemStorage
implements FileStorage {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemStorage.class);

    private static Path getFilePath() {
        return Paths.get(System.getProperty("user.dir"), "doc", "db");
    }

    private static void createDirectories(String bucket) {
        try {
            Path path = FileSystemStorage.getFilePath().resolve(bucket);
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path getFile(FileInfo fileInfo) {
        return FileSystemStorage.getFilePath().resolve(fileInfo.getBucket()).resolve(fileInfo.getFileId() + "." + fileInfo.getExtension());
    }

    public boolean supports(StorageEnum storage) {
        return StorageEnum.FileSystem == storage;
    }

    public void uploadFromStream(FileInfo fileInfo, InputStream source) {
        if (fileInfo.getFileId() == null) {
            fileInfo.setFileId(ObjectId.get());
        }
        FileSystemStorage.createDirectories((String)fileInfo.getBucket());
        Path path = this.getFile(fileInfo);
        logger.info("\u4e0a\u4f20\u6587\u4ef6\uff1a{}", (Object)path);
        try {
            Files.copy(source, path, new CopyOption[0]);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.FILE_UPLOAD_FAIL, new Object[]{fileInfo.getFileName()});
        }
    }

    public void uploadFromBytes(FileInfo fileInfo, byte[] source) {
        if (fileInfo.getFileId() == null) {
            fileInfo.setFileId(ObjectId.get());
        }
        FileSystemStorage.createDirectories((String)fileInfo.getBucket());
        Path path = this.getFile(fileInfo);
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            StreamUtils.copy((byte[])source, (OutputStream)out);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.FILE_UPLOAD_FAIL, new Object[]{fileInfo.getFileName()});
        }
    }

    public byte[] downloadToBytes(FileInfo fileInfo) {
        try {
            Path path = this.getFile(fileInfo);
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.FILE_DOWNLOAD_FAIL, new Object[]{fileInfo.getFileName()});
        }
    }

    public void downloadToStream(FileInfo fileInfo, OutputStream destination) {
        try {
            Path path = this.getFile(fileInfo);
            Files.copy(path, destination);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.FILE_DOWNLOAD_FAIL, new Object[]{fileInfo.getFileName()});
        }
    }

    public void createFile(FileInfo fileInfo) {
        fileInfo.setFileId(new ObjectId());
    }

    public long getFileSize(FileInfo fileInfo) {
        try {
            return Files.size(this.getFile(fileInfo));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteFile(FileInfo fileInfo) {
        try {
            Files.deleteIfExists(this.getFile(fileInfo));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

