/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.storage.impl;

import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.StorageEnum;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.storage.FileStorage;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.springframework.util.StreamUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ConditionalOnExpression(value="#{T(org.springframework.util.StringUtils).hasLength(environment.getProperty('dap.middleware.storage.hbase.zookeeper'))}")
public class HbaseFileStorage
implements FileStorage,
InitializingBean {
    private Configuration config;
    @Autowired
    private EnvProperties envProperties;

    public static List<byte[]> splitByteArr(byte[] bytes, int subSize) {
        int count = bytes.length % subSize == 0 ? bytes.length / subSize : bytes.length / subSize + 1;
        ArrayList subAryList = new ArrayList();
        for (int i = 0; i < count; ++i) {
            int index = i * subSize;
            ArrayList<Byte> list = new ArrayList<Byte>();
            for (int j = 0; j < subSize && index < bytes.length; ++j) {
                list.add(bytes[index++]);
            }
            subAryList.add(list);
        }
        LinkedList<byte[]> subAry = new LinkedList<byte[]>();
        for (int i = 0; i < subAryList.size(); ++i) {
            List subList = (List)subAryList.get(i);
            byte[] subAryItem = new byte[subList.size()];
            for (int j = 0; j < subList.size(); ++j) {
                subAryItem[j] = (Byte)subList.get(j);
            }
            subAry.add(subAryItem);
        }
        return subAry;
    }

    public boolean supports(StorageEnum storage) {
        return StorageEnum.DMP == storage;
    }

    public Connection getConnection() {
        try {
            return ConnectionFactory.createConnection((Configuration)this.config);
        }
        catch (IOException e) {
            throw new BusinessException("HbaseFileStorage-getConnection", (Throwable)e);
        }
    }

    public void uploadFromStream(FileInfo fileInfo, InputStream source) {
        Connection connection = null;
        Table hTable = null;
        try {
            if (fileInfo.getFileId() == null) {
                fileInfo.setFileId(ObjectId.get());
            }
            connection = this.getConnection();
            hTable = connection.getTable(TableName.valueOf((String)this.envProperties.getHbaseTable()));
            byte[] bytes = StreamUtils.copyToByteArray((InputStream)source);
            if (bytes.length == 0) {
                return;
            }
            fileInfo.setSize((long)bytes.length);
            this.putBytes(fileInfo, hTable, bytes, 0L);
        }
        catch (Exception e) {
            throw new BusinessException("HbaseFileStorage-uploadFromStream", (Throwable)e);
        }
        finally {
            if (hTable != null) {
                try {
                    hTable.close();
                }
                catch (IOException e) {
                    throw new BusinessException("HbaseFileStorage-uploadFromStream", (Throwable)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (IOException e) {
                    throw new BusinessException("HbaseFileStorage-uploadFromStream", (Throwable)e);
                }
            }
        }
    }

    private void putBytes(FileInfo fileInfo, Table hTable, byte[] bytes, long from) throws Exception {
        List bytes1 = HbaseFileStorage.splitByteArr((byte[])bytes, (int)this.envProperties.getLimit());
        fileInfo.setFilePath(null);
        String filePath = this.getFilePath(fileInfo);
        Put put01 = new Put(Bytes.toBytes((String)filePath));
        for (int i = 0; i < bytes1.size(); ++i) {
            byte[] bytes2 = (byte[])bytes1.get(i);
            byte[] bytes3 = Bytes.toBytes((String)(filePath + from + i));
            put01.addColumn(Bytes.toBytes((String)this.envProperties.getCf()), bytes3, bytes2);
        }
        hTable.put(put01);
    }

    public void uploadFromBytes(FileInfo fileInfo, byte[] source) {
        Connection connection = null;
        Table hTable = null;
        try {
            if (fileInfo.getFileId() == null) {
                fileInfo.setFileId(ObjectId.get());
            }
            if (source.length == 0) {
                return;
            }
            fileInfo.setSize((long)source.length);
            connection = this.getConnection();
            hTable = connection.getTable(TableName.valueOf((String)this.envProperties.getHbaseTable()));
            this.putBytes(fileInfo, hTable, source, 0L);
        }
        catch (Exception e) {
            throw new BusinessException("HbaseFileStorage-uploadFromBytes", (Throwable)e);
        }
        finally {
            if (hTable != null) {
                try {
                    hTable.close();
                }
                catch (IOException e) {
                    throw new BusinessException("HbaseFileStorage-uploadFromBytes", (Throwable)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (IOException e) {
                    throw new BusinessException("HbaseFileStorage-uploadFromBytes", (Throwable)e);
                }
            }
        }
    }

    public void uploadFromStream(FileInfo fileInfo, byte[] source, long from, long to, long total, Integer partNum) {
        if (source.length == 0) {
            return;
        }
        Connection connection = null;
        Table hTable = null;
        try {
            connection = this.getConnection();
            hTable = connection.getTable(TableName.valueOf((String)this.envProperties.getHbaseTable()));
            byte[] bytes = Arrays.copyOfRange(source, 0, (int)(to - from + 1L));
            this.putBytes(fileInfo, hTable, bytes, from);
        }
        catch (Exception e) {
            throw new BusinessException("HbaseFileStorage-uploadFromStream", (Throwable)e);
        }
        finally {
            if (hTable != null) {
                try {
                    hTable.close();
                }
                catch (IOException e) {
                    throw new BusinessException("HbaseFileStorage-uploadFromStream", (Throwable)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (IOException e) {
                    throw new BusinessException("HbaseFileStorage-uploadFromStream", (Throwable)e);
                }
            }
        }
    }

    public void downloadToStream(FileInfo fileInfo, OutputStream destination) {
        try {
            byte[] bytes = this.downloadToBytes(fileInfo);
            StreamUtils.copy((byte[])bytes, (OutputStream)destination);
            destination.flush();
        }
        catch (IOException e) {
            throw new BusinessException("HbaseFileStorage-downloadToStream", (Throwable)e);
        }
    }

    public void downloadPartToStream(FileInfo fileInfo, OutputStream destination, long position, long length) {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byte[] bytes = this.downloadToBytes(fileInfo);
            byteArrayInputStream = new ByteArrayInputStream(bytes);
            StreamUtils.copyRange((InputStream)byteArrayInputStream, (OutputStream)destination, (long)position, (long)(position + length));
            destination.flush();
        }
        catch (IOException e) {
            throw new BusinessException("HbaseFileStorage-downloadPartToStream", (Throwable)e);
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException e) {
                    throw new BusinessException("HbaseFileStorage-downloadPartToStream", (Throwable)e);
                }
            }
        }
    }

    public byte[] downloadToBytes(FileInfo fileInfo) {
        Connection connection = null;
        Table hTable = null;
        try {
            connection = this.getConnection();
            hTable = connection.getTable(TableName.valueOf((String)this.envProperties.getHbaseTable()));
            String filePath = fileInfo.getFilePath();
            Get get = new Get(Bytes.toBytes((String)filePath));
            Result result = hTable.get(get);
            List cells = result.listCells();
            byte[] ret = null;
            for (Cell cell : cells) {
                byte[] bytes = CellUtil.cloneValue((Cell)cell);
                if (ret == null) {
                    ret = bytes;
                    continue;
                }
                int start = ret.length;
                ret = Arrays.copyOf(ret, ret.length + bytes.length);
                System.arraycopy(bytes, 0, ret, start, bytes.length);
            }
            Iterator iterator = ret;
            return iterator;
        }
        catch (Exception e) {
            throw new BusinessException("HbaseFileStorage-downloadToBytes", (Throwable)e);
        }
        finally {
            if (hTable != null) {
                try {
                    hTable.close();
                }
                catch (IOException e) {
                    throw new BusinessException("HbaseFileStorage-downloadToBytes", (Throwable)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (IOException e) {
                    throw new BusinessException("HbaseFileStorage-downloadToBytes", (Throwable)e);
                }
            }
        }
    }

    public void deleteFile(FileInfo fileInfo) {
        Connection connection = null;
        Table hTable = null;
        try {
            connection = this.getConnection();
            hTable = connection.getTable(TableName.valueOf((String)this.envProperties.getHbaseTable()));
            String filePath = fileInfo.getFilePath();
            Delete delete = new Delete(Bytes.toBytes((String)filePath));
            delete.addFamily(Bytes.toBytes((String)this.envProperties.getCf()));
            hTable.delete(delete);
        }
        catch (Exception e) {
            throw new BusinessException("HbaseFileStorage-deleteFile", (Throwable)e);
        }
        finally {
            if (hTable != null) {
                try {
                    hTable.close();
                }
                catch (IOException e) {
                    throw new BusinessException("HbaseFileStorage-deleteFile", (Throwable)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (IOException e) {
                    throw new BusinessException("HbaseFileStorage-deleteFile", (Throwable)e);
                }
            }
        }
    }

    public void createFile(FileInfo fileInfo) {
        fileInfo.setFileId(new ObjectId());
    }

    public void afterPropertiesSet() throws Exception {
        this.config = HBaseConfiguration.create();
        this.config.set("hbase.zookeeper.quorum", this.envProperties.getHbaseZk());
        this.config.setLong("hbase.rpc.timeout", 600000L);
        this.config.setLong("hbase.client.operation.timeout", 600000L);
        this.config.setLong("hbase.client.scanner.timeout.period", 600000L);
        this.config.setLong("hbase.regionserver.lease.period", 600000L);
        this.config.set("hbase.client.ipc.pool.type", "ThreadLocalPool");
        this.config.setInt("hbase.client.ipc.pool.size", 10);
    }
}

