/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.storage.impl;

import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.StorageEnum;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.storage.FileStorage;
import com.obs.services.ObsClient;
import com.obs.services.model.AppendObjectRequest;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.springframework.util.StreamUtils;

@Service
@ConditionalOnExpression(value="#{T(org.springframework.util.StringUtils).hasLength(environment.getProperty('dap.middleware.storage.huawei.end-point'))}")
public class HuaweiFileStorage
implements FileStorage,
InitializingBean {
    private String bucket;
    private ObsClient obsClient;
    @Autowired
    private EnvProperties env;

    public boolean supports(StorageEnum storage) {
        return StorageEnum.OBS == storage;
    }

    private ObjectMetadata getMetadata(FileInfo fileInfo) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.addUserMetadata("fileSize", String.valueOf(fileInfo.getSize()));
        return metadata;
    }

    public void uploadFromStream(FileInfo fileInfo, InputStream source) {
        if (fileInfo.getSize() > 0L) {
            this.uploadOssFromStream(fileInfo, source);
        } else {
            try {
                byte[] bytes = StreamUtils.copyToByteArray((InputStream)source);
                this.uploadFromBytes(fileInfo, bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void uploadFromBytes(FileInfo fileInfo, byte[] source) {
        fileInfo.setSize((long)source.length);
        this.uploadOssFromStream(fileInfo, (InputStream)new ByteArrayInputStream(source));
    }

    private void uploadOssFromStream(FileInfo fileInfo, InputStream source) {
        if (fileInfo.getFileId() == null) {
            fileInfo.setFileId(ObjectId.get());
        }
        this.obsClient.putObject(this.bucket, this.getFilePath(fileInfo), source, this.getMetadata(fileInfo));
    }

    public void createFile(FileInfo fileInfo) {
        fileInfo.setFileId(new ObjectId());
    }

    public void uploadFromStream(FileInfo fileInfo, byte[] source, long from, long to, long total, Integer partNum) {
        AppendObjectRequest request = new AppendObjectRequest(this.bucket);
        request.setObjectKey(this.getFilePath(fileInfo));
        request.setPosition(from);
        request.setInput((InputStream)new ByteArrayInputStream(source));
        if (from == 0L) {
            request.setMetadata(this.getMetadata(fileInfo));
        }
        this.obsClient.appendObject(request);
    }

    public void downloadToStream(FileInfo fileInfo, OutputStream destination) {
        ObsObject obsObject = this.obsClient.getObject(this.bucket, fileInfo.getFilePath());
        try {
            StreamUtils.copy((InputStream)obsObject.getObjectContent(), (OutputStream)destination);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void downloadPartToStream(FileInfo fileInfo, OutputStream destination, long position, long length) {
        GetObjectRequest request = new GetObjectRequest(this.bucket, fileInfo.getFilePath());
        request.setRangeStart(Long.valueOf(position));
        request.setRangeEnd(Long.valueOf(position + length - 1L));
        ObsObject obsObject = this.obsClient.getObject(request);
        try {
            StreamUtils.copy((InputStream)obsObject.getObjectContent(), (OutputStream)destination);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] downloadToBytes(FileInfo fileInfo) {
        ObsObject obsObject = this.obsClient.getObject(this.bucket, fileInfo.getFilePath());
        try {
            return StreamUtils.copyToByteArray((InputStream)obsObject.getObjectContent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteFile(FileInfo fileInfo) {
        this.obsClient.deleteObject(this.bucket, fileInfo.getFilePath());
    }

    public void afterPropertiesSet() throws Exception {
        this.bucket = this.env.getHuaweiBucket();
        this.obsClient = new ObsClient(this.env.getHuaweiAccessKey(), this.env.getHuaweiSecretKey(), this.env.getHuaweiEndPoint());
    }
}

