/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.storage.impl;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.domain.enumeration.StorageEnum;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.storage.FileStorage;
import com.digiwin.dap.middleware.dmc.storage.gridfs.MongoConfiguration;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.model.Filters;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbStorage
implements FileStorage {
    private static final Logger logger = LoggerFactory.getLogger(MongoDbStorage.class);
    private final Object partWriteLock = new Object();
    private final GridFSBucket gridFSBucket;

    public MongoDbStorage(MongoConfiguration mongoConfiguration) {
        this.gridFSBucket = mongoConfiguration.getGridFSBucket();
    }

    public boolean supports(StorageEnum storage) {
        return StorageEnum.MongoDB == storage;
    }

    public void uploadFromStream(FileInfo fileInfo, InputStream source) {
        if (fileInfo.getFileId() != null) {
            this.gridFSBucket.uploadFromStream((BsonValue)new BsonObjectId(fileInfo.getFileId()), fileInfo.getFileName(), source, new GridFSUploadOptions());
        } else {
            ObjectId fileId = this.gridFSBucket.uploadFromStream(fileInfo.getFileName(), source, new GridFSUploadOptions());
            fileInfo.setFileId(fileId);
        }
    }

    public void uploadFromBytes(FileInfo fileInfo, byte[] source) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(source);
        if (fileInfo.getFileId() != null) {
            this.gridFSBucket.uploadFromStream((BsonValue)new BsonObjectId(fileInfo.getFileId()), fileInfo.getFileName(), (InputStream)inputStream, new GridFSUploadOptions());
        } else {
            ObjectId fileId = this.gridFSBucket.uploadFromStream(fileInfo.getFileName(), (InputStream)inputStream, new GridFSUploadOptions());
            fileInfo.setFileId(fileId);
        }
    }

    public void createFile(FileInfo fileInfo) {
        byte[] bytes = new byte[]{};
        ObjectId fileId = this.gridFSBucket.uploadFromStream(fileInfo.getFileName(), (InputStream)new ByteArrayInputStream(bytes), new GridFSUploadOptions());
        fileInfo.setFileId(fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFromStream(FileInfo fileInfo, byte[] source, long from, long to, long total, Integer partNum) {
        GridFSFile file = this.getGridFile(fileInfo.getFileId());
        Object object = this.partWriteLock;
        synchronized (object) {
            int uploadLen = (int)(to - from + 1L);
            if (source.length > uploadLen) {
                byte[] newSource = new byte[uploadLen];
                System.arraycopy(source, 0, newSource, 0, uploadLen);
                this.gridFSBucket.uploadFromStream((BsonValue)new BsonObjectId(file.getObjectId()), file.getFilename(), (InputStream)new ByteArrayInputStream(newSource));
            } else {
                this.gridFSBucket.uploadFromStream((BsonValue)new BsonObjectId(file.getObjectId()), file.getFilename(), (InputStream)new ByteArrayInputStream(source));
            }
        }
    }

    public void downloadToStream(FileInfo fileInfo, OutputStream destination) {
        this.gridFSBucket.downloadToStream(fileInfo.getFileId(), destination);
    }

    public void downloadPartToStream(FileInfo fileInfo, OutputStream destination, long position, long length) {
        try (GridFSDownloadStream stream = this.gridFSBucket.openDownloadStream(fileInfo.getFileId());){
            int read;
            stream.skip(position);
            byte[] buffer = new byte[261120];
            for (long toLen = 0L; toLen < length && (read = stream.read(buffer, 0, buffer.length)) > 0; toLen += (long)read) {
                if (toLen + (long)read > length) {
                    destination.write(buffer, 0, (int)(length - toLen));
                    continue;
                }
                destination.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.FILE_DOWNLOAD_FAIL, e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] downloadToBytes(FileInfo fileInfo) {
        try (GridFSDownloadStream stream = this.gridFSBucket.openDownloadStream(fileInfo.getFileId());){
            int tmp;
            int len;
            GridFSFile fsFile = stream.getGridFSFile();
            int size = fsFile.getChunkSize();
            int readSize = Math.min(len, size);
            byte[] returnBts = new byte[len];
            int offset = 0;
            for (len = (int)fsFile.getLength(); len > 0; len -= tmp) {
                if (len > readSize) {
                    tmp = stream.read(returnBts, offset, readSize);
                    offset += tmp;
                    continue;
                }
                tmp = stream.read(returnBts, offset, len);
            }
            byte[] byArray = returnBts;
            return byArray;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.FILE_DOWNLOAD_FAIL, e.getMessage());
        }
    }

    public void deleteFile(FileInfo fileInfo) {
        this.gridFSBucket.delete(fileInfo.getFileId());
    }

    public long getFileSize(FileInfo fileInfo) {
        return this.getGridFile(fileInfo.getFileId()).getLength();
    }

    private GridFSFile getGridFile(ObjectId fileId) {
        GridFSFile gridFile = (GridFSFile)this.gridFSBucket.find(Filters.eq((String)"_id", (Object)fileId)).first();
        if (gridFile == null) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_NONE, new Object[]{fileId});
        }
        return gridFile;
    }
}

