/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.storage.impl;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.domain.enumeration.MimeType;
import com.digiwin.dap.middleware.dmc.domain.enumeration.StorageEnum;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.storage.FileStorage;
import com.digiwin.dap.middleware.dmc.storage.impl.TenantCustomStorage;
import com.digiwin.dap.middleware.dmc.support.context.StorageContextHolder;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.ThirdCallException;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class TenantCustomStorage
implements FileStorage {
    private static final Logger logger = LoggerFactory.getLogger(TenantCustomStorage.class);
    private static final String FILE_UPLOAD = "/api/file/upload";
    private static final String FILE_UPLOAD_PART = "/api/file/upload/part";
    private static final String FILE_DOWNLOAD = "/api/file/download";
    private static final String FILE_DOWNLOAD_PART = "/api/file/download/part";
    private static final String FILE_DELETE = "/api/file/delete";
    private static final String FILE_INFO_ADD = "/api/file/info/add";
    private static final String FILE_INFO_FIND = "/api/file/info/find";
    private final String backUri;
    private final RestTemplate restTemplate;

    public TenantCustomStorage(String backUri, RestTemplate restTemplate) {
        this.backUri = backUri;
        this.restTemplate = restTemplate;
    }

    private static boolean isValid(String spec) {
        try {
            new URL(spec);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static HttpEntity<?> requestBody(String tenantId, Object data, MediaType mediaType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(mediaType);
        tenantId = Optional.ofNullable(tenantId).orElse("default");
        headers.setBasicAuth(tenantId, tenantId, StandardCharsets.UTF_8);
        return new HttpEntity(data, (MultiValueMap)headers);
    }

    public boolean supports(StorageEnum storage) {
        return StorageEnum.TenantCustom == storage;
    }

    public void uploadFromStream(FileInfo fileInfo, InputStream source) {
        if (fileInfo.getFileId() == null) {
            fileInfo.setFileId(ObjectId.get());
        }
        String url = this.backUri + "/api/file/upload";
        try {
            MultipartBodyBuilder builder = new MultipartBodyBuilder();
            builder.part("file", (Object)new InputStreamResource(source)).headers(headers -> {
                headers.setContentType(MimeType.parse((String)fileInfo.getContentType()));
                headers.setContentDisposition(ContentDisposition.formData().name("file").filename(fileInfo.getFileName()).build());
            });
            builder.part("bucket", (Object)fileInfo.getBucket());
            builder.part("fileId", (Object)fileInfo.getFileId().toString());
            builder.part("storageParams", (Object)JsonUtils.objToJson((Object)StorageContextHolder.getContext()));
            HttpEntity request = TenantCustomStorage.requestBody((String)fileInfo.getTenantId(), (Object)builder.build(), (MediaType)MediaType.MULTIPART_FORM_DATA);
            StdData stdData = (StdData)this.restTemplate.postForObject(url, (Object)request, StdData.class, new Object[0]);
            logger.info("TenantCustomStorage.uploadFromStream success,url:{},bucket:{},fileId:{},storageParams:{},result:{}", new Object[]{url, fileInfo.getBucket(), fileInfo.getFileId().toString(), JsonUtils.objToJson((Object)StorageContextHolder.getContext()), JsonUtils.objToJson((Object)stdData)});
            if (stdData == null || !Objects.equals(200, stdData.getCode())) {
                throw new BusinessException((ErrorHandler)I18nError.FILE_UPLOAD_FAIL, new Object[]{fileInfo.getFileName()});
            }
        }
        catch (HttpStatusCodeException e) {
            logger.error("TenantCustomStorage.uploadFromStream fail,url:{},bucket:{},fileId:{},storageParams:{}", new Object[]{url, fileInfo.getBucket(), fileInfo.getFileId().toString(), JsonUtils.objToJson((Object)StorageContextHolder.getContext()), e});
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.BUSINESS, url, (Exception)((Object)e));
        }
    }

    public void uploadFromBytes(FileInfo fileInfo, byte[] source) {
        if (fileInfo.getFileId() == null) {
            fileInfo.setFileId(ObjectId.get());
        }
        String url = this.backUri + "/api/file/upload";
        try {
            MultipartBodyBuilder builder = new MultipartBodyBuilder();
            builder.part("file", (Object)new InputStreamResource((InputStream)new ByteArrayInputStream(source))).headers(headers -> {
                headers.setContentType(MimeType.parse((String)fileInfo.getContentType()));
                headers.setContentDisposition(ContentDisposition.formData().name("file").filename(fileInfo.getFileName()).build());
            });
            builder.part("bucket", (Object)fileInfo.getBucket());
            builder.part("fileId", (Object)fileInfo.getFileId().toString());
            builder.part("storageParams", (Object)JsonUtils.objToJson((Object)StorageContextHolder.getContext()));
            HttpEntity request = TenantCustomStorage.requestBody((String)fileInfo.getTenantId(), (Object)builder.build(), (MediaType)MediaType.MULTIPART_FORM_DATA);
            StdData stdData = (StdData)this.restTemplate.postForObject(url, (Object)request, StdData.class, new Object[0]);
            logger.info("TenantCustomStorage.uploadFromBytes success,url:{},bucket:{},fileId:{},storageParams:{},result:{}", new Object[]{url, fileInfo.getBucket(), fileInfo.getFileId().toString(), JsonUtils.objToJson((Object)StorageContextHolder.getContext()), JsonUtils.objToJson((Object)stdData)});
            if (stdData == null || !Objects.equals(200, stdData.getCode())) {
                throw new BusinessException((ErrorHandler)I18nError.FILE_UPLOAD_FAIL, new Object[]{fileInfo.getFileName()});
            }
        }
        catch (HttpStatusCodeException e) {
            logger.error("TenantCustomStorage.uploadFromBytes fail,url:{},bucket:{},fileId:{},storageParams:{}", new Object[]{url, fileInfo.getBucket(), fileInfo.getFileId().toString(), JsonUtils.objToJson((Object)StorageContextHolder.getContext()), e});
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.BUSINESS, url, (Exception)((Object)e));
        }
    }

    public void createFile(FileInfo fileInfo) {
        fileInfo.setFileId(ObjectId.get());
        String url = this.backUri + "/api/file/info/add";
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("bucket", fileInfo.getBucket());
            data.put("fileId", fileInfo.getFileId().toString());
            data.put("fileName", fileInfo.getFileName());
            data.put("storageParams", JsonUtils.objToJson((Object)StorageContextHolder.getContext()));
            HttpEntity request = TenantCustomStorage.requestBody((String)fileInfo.getTenantId(), data, (MediaType)MediaType.APPLICATION_JSON);
            StdData stdData = (StdData)this.restTemplate.postForObject(url, (Object)request, StdData.class, new Object[0]);
            logger.info("TenantCustomStorage.createFile success,url:{},bucket:{},fileId:{},fileName:{},storageParams:{},result:{}", new Object[]{url, fileInfo.getBucket(), fileInfo.getFileId().toString(), fileInfo.getFileName(), JsonUtils.objToJson((Object)StorageContextHolder.getContext()), JsonUtils.objToJson((Object)stdData)});
            if (stdData == null || !Objects.equals(200, stdData.getCode())) {
                throw new BusinessException((ErrorHandler)I18nError.FILE_CREATE_FAIL, new Object[]{fileInfo.getFileName()});
            }
        }
        catch (HttpStatusCodeException e) {
            logger.info("TenantCustomStorage.createFile fail,url:{},bucket:{},fileId:{},fileName:{},storageParams:{}", new Object[]{url, fileInfo.getBucket(), fileInfo.getFileId().toString(), fileInfo.getFileName(), JsonUtils.objToJson((Object)StorageContextHolder.getContext()), e});
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.BUSINESS, url, (Exception)((Object)e));
        }
    }

    public void uploadFromStream(FileInfo fileInfo, byte[] source, long from, long to, long total, Integer partNum) {
        String url = this.backUri + "/api/file/upload/part";
        try {
            MultipartBodyBuilder builder = new MultipartBodyBuilder();
            builder.part("file", (Object)new ByteArrayResource(source)).headers(headers -> {
                headers.setContentType(MimeType.parse((String)fileInfo.getContentType()));
                headers.setContentDisposition(ContentDisposition.formData().name("file").filename(fileInfo.getFileName()).build());
            });
            builder.part("bucket", (Object)fileInfo.getBucket());
            builder.part("fileId", (Object)fileInfo.getFileId().toString());
            builder.part("from", (Object)String.valueOf(from));
            builder.part("to", (Object)String.valueOf(to));
            builder.part("size", (Object)String.valueOf(total));
            builder.part("storageParams", (Object)JsonUtils.objToJson((Object)StorageContextHolder.getContext()));
            HttpEntity request = TenantCustomStorage.requestBody((String)fileInfo.getTenantId(), (Object)builder.build(), (MediaType)MediaType.MULTIPART_FORM_DATA);
            StdData stdData = (StdData)this.restTemplate.postForObject(url, (Object)request, StdData.class, new Object[0]);
            logger.info("TenantCustomStorage.uploadFromStream success,url:{},bucket:{},fileId:{},from:{},to:{},size:{},storageParams:{},result:{}", new Object[]{url, fileInfo.getBucket(), fileInfo.getFileId().toString(), from, to, total, JsonUtils.objToJson((Object)StorageContextHolder.getContext()), JsonUtils.objToJson((Object)stdData)});
            if (stdData == null || !Objects.equals(200, stdData.getCode())) {
                throw new BusinessException((ErrorHandler)I18nError.FILE_UPLOAD_FAIL, new Object[]{fileInfo.getFileName()});
            }
        }
        catch (HttpStatusCodeException e) {
            logger.info("TenantCustomStorage.uploadFromStream fail,url:{},bucket:{},fileId:{},from:{},to:{},size:{},storageParams:{}", new Object[]{url, fileInfo.getBucket(), fileInfo.getFileId().toString(), from, to, total, JsonUtils.objToJson((Object)StorageContextHolder.getContext()), e});
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.BUSINESS, url, (Exception)((Object)e));
        }
    }

    public void downloadToStream(FileInfo fileInfo, OutputStream destination) {
        String url = this.backUri + "/api/file/download";
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("fileId", fileInfo.getFileId().toString());
            data.put("storageParams", JsonUtils.objToJson((Object)StorageContextHolder.getContext()));
            HttpEntity request = TenantCustomStorage.requestBody((String)fileInfo.getTenantId(), data, (MediaType)MediaType.APPLICATION_JSON);
            byte[] bytes = (byte[])this.restTemplate.postForObject(url, (Object)request, byte[].class, new Object[0]);
            destination.write(bytes);
            logger.info("TenantCustomStorage.downloadToStream success,url:{},fileId:{},storageParams:{},size:{}", new Object[]{url, fileInfo.getFileId().toString(), JsonUtils.objToJson((Object)StorageContextHolder.getContext()), bytes.length});
        }
        catch (HttpStatusCodeException e) {
            logger.info("TenantCustomStorage.downloadToStream fail,url:{},fileId:{},storageParams:{}", new Object[]{url, fileInfo.getFileId().toString(), JsonUtils.objToJson((Object)StorageContextHolder.getContext()), e});
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.BUSINESS, url, (Exception)((Object)e));
        }
        catch (IOException e) {
            logger.info("TenantCustomStorage.downloadToStream fail,url:{},fileId:{},storageParams:{}", new Object[]{url, fileInfo.getFileId().toString(), JsonUtils.objToJson((Object)StorageContextHolder.getContext()), e});
            throw new RuntimeException(e);
        }
    }

    public void downloadPartToStream(FileInfo fileInfo, OutputStream destination, long position, long length) {
        String url = this.backUri + "/api/file/download/part";
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("fileId", fileInfo.getFileId().toString());
            data.put("position", position);
            data.put("length", length);
            data.put("storageParams", JsonUtils.objToJson((Object)StorageContextHolder.getContext()));
            HttpEntity request = TenantCustomStorage.requestBody((String)fileInfo.getTenantId(), data, (MediaType)MediaType.APPLICATION_JSON);
            byte[] bytes = (byte[])this.restTemplate.postForObject(url, (Object)request, byte[].class, new Object[0]);
            destination.write(bytes);
            logger.info("TenantCustomStorage.downloadPartToStream success,url:{},fileId:{},position:{},length:{},storageParams:{},size:{}", new Object[]{url, fileInfo.getFileId().toString(), position, length, JsonUtils.objToJson((Object)StorageContextHolder.getContext()), bytes.length});
        }
        catch (HttpStatusCodeException e) {
            logger.info("TenantCustomStorage.downloadPartToStream fail,url:{},fileId:{},storageParams:{}", new Object[]{url, fileInfo.getFileId().toString(), JsonUtils.objToJson((Object)StorageContextHolder.getContext()), e});
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.BUSINESS, url, (Exception)((Object)e));
        }
        catch (IOException e) {
            logger.info("TenantCustomStorage.downloadPartToStream fail,url:{},fileId:{},storageParams:{}", new Object[]{url, fileInfo.getFileId().toString(), JsonUtils.objToJson((Object)StorageContextHolder.getContext()), e});
            throw new RuntimeException(e);
        }
    }

    public byte[] downloadToBytes(FileInfo fileInfo) {
        String url = this.backUri + "/api/file/download";
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("fileId", fileInfo.getFileId().toString());
            data.put("storageParams", JsonUtils.objToJson((Object)StorageContextHolder.getContext()));
            HttpEntity request = TenantCustomStorage.requestBody((String)fileInfo.getTenantId(), data, (MediaType)MediaType.APPLICATION_JSON);
            byte[] bytes = (byte[])this.restTemplate.postForObject(url, (Object)request, byte[].class, new Object[0]);
            logger.info("TenantCustomStorage.downloadToBytes fail,url:{},fileId:{},storageParams:{},size:{}", new Object[]{url, fileInfo.getFileId().toString(), JsonUtils.objToJson((Object)StorageContextHolder.getContext()), bytes != null ? bytes.length : 0});
            return bytes;
        }
        catch (HttpStatusCodeException e) {
            logger.info("TenantCustomStorage.downloadToBytes fail,url:{},fileId:{},storageParams:{}", new Object[]{url, fileInfo.getFileId().toString(), JsonUtils.objToJson((Object)StorageContextHolder.getContext()), e});
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.BUSINESS, url, (Exception)((Object)e));
        }
    }

    public void deleteFile(FileInfo fileInfo) {
        String url = this.backUri + "/api/file/delete";
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("fileId", fileInfo.getFileId().toString());
            data.put("storageParams", JsonUtils.objToJson((Object)StorageContextHolder.getContext()));
            HttpEntity request = TenantCustomStorage.requestBody((String)fileInfo.getTenantId(), data, (MediaType)MediaType.APPLICATION_JSON);
            StdData stdData = (StdData)this.restTemplate.postForObject(url, (Object)request, StdData.class, new Object[0]);
            logger.info("TenantCustomStorage.deleteFile fail,url:{},fileId:{},storageParams:{},result:{}", new Object[]{url, fileInfo.getFileId().toString(), JsonUtils.objToJson((Object)StorageContextHolder.getContext()), JsonUtils.objToJson((Object)stdData)});
            if (stdData == null || !Objects.equals(200, stdData.getCode())) {
                throw new BusinessException((ErrorHandler)I18nError.FILE_DELETE_FAIL, new Object[]{fileInfo.getFileName()});
            }
        }
        catch (HttpStatusCodeException e) {
            logger.info("TenantCustomStorage.deleteFile fail,url:{},fileId:{},storageParams:{}", new Object[]{url, fileInfo.getFileId().toString(), JsonUtils.objToJson((Object)StorageContextHolder.getContext()), e});
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.BUSINESS, url, (Exception)((Object)e));
        }
    }

    public long getFileSize(FileInfo fileInfo) {
        String url = this.backUri + "/api/file/info/find";
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("fileId", fileInfo.getFileId().toString());
            data.put("storageParams", JsonUtils.objToJson((Object)StorageContextHolder.getContext()));
            HttpEntity request = TenantCustomStorage.requestBody((String)fileInfo.getTenantId(), data, (MediaType)MediaType.APPLICATION_JSON);
            1 responseType = new /* Unavailable Anonymous Inner Class!! */;
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)responseType, new Object[0]);
            StdData stdData = (StdData)response.getBody();
            logger.info("TenantCustomStorage.getFileSize fail,url:{},fileId:{},storageParams:{},result:{}", new Object[]{url, fileInfo.getFileId().toString(), JsonUtils.objToJson((Object)StorageContextHolder.getContext()), JsonUtils.objToJson((Object)stdData)});
            if (stdData == null || !Objects.equals(200, stdData.getCode())) {
                throw new BusinessException((ErrorHandler)I18nError.FILE_FIND_FAIL, new Object[]{fileInfo.getFileName()});
            }
            return ((FileInfo)stdData.getData()).getSize();
        }
        catch (HttpStatusCodeException e) {
            logger.info("TenantCustomStorage.getFileSize fail,url:{},fileId:{},storageParams:{}", new Object[]{url, fileInfo.getFileId().toString(), JsonUtils.objToJson((Object)StorageContextHolder.getContext()), e});
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.BUSINESS, url, (Exception)((Object)e));
        }
    }
}

