/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support;

import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.storage.FileStorage;
import com.digiwin.dap.middleware.dmc.support.HashingUploadWrapper;
import com.digiwin.dap.middleware.dmc.support.context.BucketContextHolder;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;

public class HashingUploadWrapper {
    private final boolean enableHash;
    private final String hashAlgorithm = "SHA-256";

    private HashingUploadWrapper(boolean enableHash) {
        this.enableHash = enableHash;
    }

    public static HashingUploadWrapper of() {
        return new HashingUploadWrapper(BucketContextHolder.isHash());
    }

    public static HashingUploadWrapper of(boolean enableHash) {
        return new HashingUploadWrapper(enableHash);
    }

    public void uploadFromStream(FileStorage fileStorage, FileInfo fileInfo, InputStream source) {
        if (!this.enableHash) {
            fileStorage.uploadFromStream(fileInfo, source);
            return;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            HashingInputStream his = new HashingInputStream(source, digest);
            fileStorage.uploadFromStream(fileInfo, (InputStream)his);
            fileInfo.setHash(his.getHexDigest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Hashing upload failed", e);
        }
    }

    public void uploadFromBytes(FileStorage fileStorage, FileInfo fileInfo, byte[] source) {
        fileStorage.uploadFromBytes(fileInfo, source);
        if (this.enableHash) {
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                String hex = Hex.encodeHexString((byte[])digest.digest(source));
                fileInfo.setHash(hex);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Hashing upload failed", e);
            }
        }
    }

    public void uploadFromStream(FileStorage fileStorage, FileInfo fileInfo) {
        if (!this.enableHash) {
            return;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            DigestOutputStream digestOut = new DigestOutputStream((OutputStream)new NullOutputStream(), digest);
            fileStorage.downloadToStream(fileInfo, (OutputStream)digestOut);
            fileInfo.setHash(Hex.encodeHexString((byte[])digest.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Hashing after download failed", e);
        }
    }
}

