/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.aspect;

import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.enumeration.FidType;
import com.digiwin.dap.middleware.dmc.service.business.FidCheckService;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Order(value=2)
@Component
@Aspect
public class AccessCheckHandlerInterceptor {
    private static final String BUCKET = "bucket";
    @Autowired
    private FidCheckService fidCheckService;

    private static RoleAuthorize getAnnotation(Method method) {
        RoleAuthorize roleAuthorize = method.getAnnotation(RoleAuthorize.class);
        if (roleAuthorize != null) {
            return roleAuthorize;
        }
        return method.getDeclaringClass().getAnnotation(RoleAuthorize.class);
    }

    @Before(value="@annotation(com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize)")
    public void fidCheck(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Parameter[] parameters = methodSignature.getMethod().getParameters();
        String bucket = null;
        Object[] values = joinPoint.getArgs();
        for (int i = 0; i < parameters.length; ++i) {
            if (!"bucket".equals(parameters[i].getName())) continue;
            bucket = (String)values[i];
            break;
        }
        if (ObjectUtils.isEmpty(bucket)) {
            return;
        }
        RoleAuthorize roleAuthorize = AccessCheckHandlerInterceptor.getAnnotation((Method)methodSignature.getMethod());
        if (roleAuthorize != null) {
            int[] fileIndexes;
            this.fidCheckService.bucketAccess(bucket, roleAuthorize, values);
            for (int fileIndex : fileIndexes = roleAuthorize.fileIndexes()) {
                this.fidCheckService.canOperateId(FidType.File, bucket, String.valueOf(values[fileIndex]));
            }
        }
    }
}

