/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.aspect;

import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.support.context.BucketContextHolder;
import com.digiwin.dap.middleware.dmc.support.context.StorageContext;
import com.digiwin.dap.middleware.dmc.support.context.StorageContextHolder;
import java.util.concurrent.Callable;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.async.CallableProcessingInterceptor;

public final class AppAuthContextCallableProcessingInterceptor
implements CallableProcessingInterceptor {
    private volatile AppAuthContext appAuthContext;
    private volatile StorageContext storageContext;
    private volatile Bucket bucketContext;

    public <T> void beforeConcurrentHandling(NativeWebRequest request, Callable<T> task) {
        if (this.appAuthContext == null) {
            this.setSecurityContext(AppAuthContextHolder.getContext());
        }
        if (this.storageContext == null) {
            this.setStorageContext(StorageContextHolder.getContext());
        }
        if (this.bucketContext == null) {
            this.setBucketContext(BucketContextHolder.getContext());
        }
    }

    public <T> void preProcess(NativeWebRequest request, Callable<T> task) {
        AppAuthContextHolder.setContext((AppAuthContext)this.appAuthContext);
        StorageContextHolder.setContext((StorageContext)this.storageContext);
        BucketContextHolder.setContext((Bucket)this.bucketContext);
    }

    public <T> void postProcess(NativeWebRequest request, Callable<T> task, Object concurrentResult) {
        AppAuthContextHolder.clearContext();
        StorageContextHolder.clearContext();
        BucketContextHolder.clearContext();
    }

    private void setSecurityContext(AppAuthContext securityContext) {
        this.appAuthContext = securityContext;
    }

    private void setStorageContext(StorageContext storageContext) {
        this.storageContext = storageContext;
    }

    public void setBucketContext(Bucket bucketContext) {
        this.bucketContext = bucketContext;
    }
}

