/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.aspect;

import com.digiwin.dap.middleware.dmc.domain.annotation.LoginMark;
import com.digiwin.dap.middleware.dmc.domain.enumeration.LogType;
import com.digiwin.dap.middleware.dmc.repository.OpLogRepository;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class LoginLogHandlerInterceptor {
    @Autowired
    private OpLogRepository opLogRepository;

    @AfterReturning(value="@annotation(com.digiwin.dap.middleware.dmc.domain.annotation.LoginMark)", returning="obj")
    public void loginLog(JoinPoint joinPoint, Object obj) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        LoginMark loginMark = methodSignature.getMethod().getAnnotation(LoginMark.class);
        if (loginMark != null) {
            Object object = joinPoint.getArgs()[0];
            this.opLogRepository.saveLog(LogType.SYSTEM_LOGIN, loginMark.value().desc(), object);
        }
    }

    @AfterThrowing(value="@annotation(com.digiwin.dap.middleware.dmc.domain.annotation.LoginMark)")
    public void loginFailLog(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        LoginMark loginMark = methodSignature.getMethod().getAnnotation(LoginMark.class);
        if (loginMark != null) {
            Object object = joinPoint.getArgs()[0];
            this.opLogRepository.saveLog(LogType.SYSTEM_LOGIN, loginMark.value().desc(), object, false);
        }
    }
}

