/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.aspect;

import com.digiwin.dap.middleware.dmc.domain.annotation.UploadMark;
import com.digiwin.dap.middleware.dmc.entity.ResourceGoodsPurchaseRecord;
import com.digiwin.dap.middleware.dmc.service.admin.BucketService;
import com.digiwin.dap.middleware.dmc.service.resource.goods.ResourceGoodsBizService;
import com.digiwin.dap.middleware.dmc.support.context.UploadContext;
import com.digiwin.dap.middleware.dmc.support.context.UploadContextHolder;
import com.digiwin.dap.middleware.util.UserUtils;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Order(value=3)
@Component
@Aspect
public class UploadCheckHandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(UploadCheckHandlerInterceptor.class);
    @Autowired
    private BucketService bucketService;
    @Autowired
    private ResourceGoodsBizService resourceGoodsBizService;

    @Pointcut(value="@annotation(com.digiwin.dap.middleware.dmc.domain.annotation.UploadMark)")
    public void uploadPointcut() {
    }

    @Before(value="uploadPointcut()")
    public void beforeUpload(JoinPoint joinPoint) throws IOException {
        Object[] args = joinPoint.getArgs();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        UploadMark uploadMark = methodSignature.getMethod().getAnnotation(UploadMark.class);
        String bucketName = String.valueOf(args[0]);
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        long fileSize = 0L;
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            fileSize = request.getContentLengthLong();
        }
        String tenantId = UserUtils.getTenantId();
        logger.info("\u79df\u6237{}\u4e0b\u5b58\u50a8\u6876{}\u4e0a\u4f20{}\u5b57\u8282\u6587\u4ef6", new Object[]{tenantId, bucketName, fileSize});
        if (uploadMark != null) {
            this.bucketService.checkBucketLimit(bucketName, tenantId, fileSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterReturning(value="uploadPointcut()", returning="result")
    public void logUpload(JoinPoint joinPoint, Object result) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        UploadMark uploadMark = methodSignature.getMethod().getAnnotation(UploadMark.class);
        UploadContext uploadContext = UploadContextHolder.getContext();
        if (uploadMark != null) {
            try {
                ResourceGoodsPurchaseRecord resourceGoodsPurchaseRecord = uploadContext.getResourceGoodsPurchaseRecord();
                this.resourceGoodsBizService.updateOccupiedCapacity(resourceGoodsPurchaseRecord, uploadContext.getBucket(), uploadContext.getOccupiedCapacity(), uploadContext.getAppId());
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
            finally {
                UploadContextHolder.clear();
            }
        }
    }
}

