/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.auth;

import com.digiwin.dap.middleware.dmc.support.aspect.AppAuthContextCallableProcessingInterceptor;
import com.digiwin.dap.middleware.dmc.support.context.StorageContext;
import com.digiwin.dap.middleware.dmc.support.context.StorageContextHolder;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.async.CallableProcessingInterceptor;
import org.springframework.web.context.request.async.WebAsyncManager;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public final class DapAsyncManagerIntegrationFilter
extends OncePerRequestFilter {
    private static final Object DAP_CALLABLE_INTERCEPTOR_KEY = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        WebAsyncManager asyncManager = WebAsyncUtils.getAsyncManager((ServletRequest)request);
        AppAuthContextCallableProcessingInterceptor callableInterceptor = (AppAuthContextCallableProcessingInterceptor)asyncManager.getCallableInterceptor(DAP_CALLABLE_INTERCEPTOR_KEY);
        if (callableInterceptor == null) {
            asyncManager.registerCallableInterceptor(DAP_CALLABLE_INTERCEPTOR_KEY, (CallableProcessingInterceptor)new AppAuthContextCallableProcessingInterceptor());
        }
        try {
            String storageParams = request.getParameter("storageParams");
            String storageParamsHeader = request.getHeader("digi-middleware-storage-params");
            if (StringUtils.hasText((String)storageParams)) {
                StorageContextHolder.setContext((StorageContext)((StorageContext)JsonUtils.readValue((String)storageParams, StorageContext.class)));
            } else if (StringUtils.hasText((String)storageParamsHeader)) {
                StorageContextHolder.setContext((StorageContext)((StorageContext)JsonUtils.readValue((String)storageParamsHeader, StorageContext.class)));
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            StorageContextHolder.clearContext();
        }
    }
}

