/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.auth;

import com.digiwin.dap.middle.support.DefaultDapSecuritySupport;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.domain.enumeration.CloudEnum;
import com.digiwin.dap.middleware.dmc.domain.enumeration.LogType;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.repository.OpLogRepository;
import com.digiwin.dap.middleware.dmc.service.login.LoginContext;
import com.digiwin.dap.middleware.dmc.service.login.token.DriveTokenService;
import com.digiwin.dap.middleware.dmc.support.auth.DapAsyncManagerIntegrationFilter;
import com.digiwin.dap.middleware.dmc.support.auth.domain.DriveAuth;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtGrantedAuthority;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtUser;
import com.digiwin.dap.middleware.dmc.support.context.BucketContextHolder;
import com.digiwin.dap.middleware.dmc.support.context.FileOpTreeContextHolder;
import com.digiwin.dap.middleware.dmc.util.TenantUtil;
import com.digiwin.dap.middleware.dmc.util.UserUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.context.request.async.WebAsyncManagerIntegrationFilter;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DmcSecuritySupport
extends DefaultDapSecuritySupport {
    @Value(value="${dap.middleware.dmc.cloud:0}")
    private Integer cloud;
    @Value(value="${dap.middleware.dmc.frame-ancestors:}")
    private String frameAncestors;
    @Autowired
    private LoginContext loginContext;
    @Autowired
    private OpLogRepository opLogRepository;
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private DriveTokenService driveTokenService;

    public String[] getWhiteList() {
        return new String[]{"/**/auth/**", "/**/test/**", "/**/share/**", "/**/preview/**", "/**/download/**", "/**/playvideo/**", "/**/toAnyOne/**", "/api/dmc/v2/buckets/task", "/api/dmc/v2/buckets/apply", "/api/dmc/v2/user/password/**", "/api/dmc/3rd/**"};
    }

    public List<String> getAppTokenWhiteList() {
        List whiteList = super.getAppTokenWhiteList();
        whiteList.add("/share");
        whiteList.add("/preview");
        whiteList.add("/playvideo");
        whiteList.add("/toAnyOne");
        whiteList.add("/api/dmc/3rd");
        return whiteList;
    }

    public AuthoredUser getLoginUser(HttpServletRequest request, String userToken) {
        JwtUser jwtUser = this.loginContext.analysis(userToken, request);
        this.setTenantId(request, jwtUser);
        List buckets = this.bucketRepository.findByOwner(jwtUser.getUserId());
        for (Bucket bucket : buckets) {
            jwtUser.getBuckets().add(bucket.getName());
        }
        return jwtUser;
    }

    public AuthoredSys getLoginSys(HttpServletRequest request, String appId) {
        if (UserUtil.isIam() && this.cloud.intValue() != CloudEnum.COA.id()) {
            return super.getLoginSys(request, appId);
        }
        AuthoredSys authoredSys = new AuthoredSys(appId);
        authoredSys.setInside(true);
        return authoredSys;
    }

    public AuthoredUser anonymous() {
        return JwtUser.anonymous();
    }

    public void postProcessToken(HttpServletRequest request, HttpServletResponse response) {
        String tenantId;
        String driveToken = request.getHeader(GlobalConstants.HTTP_HEADER_DRIVE_TOKEN_KEY);
        if (StringUtils.hasLength((String)driveToken)) {
            this.opLogRepository.saveLog(LogType.EVENT_TRACKING, "\u89e3\u6790DriveToken", null);
            if (this.driveTokenService.validate(driveToken)) {
                DriveAuth driveAuth = (DriveAuth)this.driveTokenService.getData(driveToken);
                UserUtil.getJwtUser().getAuthorities().add(new JwtGrantedAuthority(driveAuth));
                request.setAttribute("digi-middleware-auth-access-data", (Object)driveAuth);
            } else {
                throw new BusinessException((ErrorHandler)I18nError.LOGIN_DRIVE_TOKEN_INVALID);
            }
        }
        if ((tenantId = request.getHeader(GlobalConstants.HTTP_HEADER_TENANT_ID_KEY)) != null) {
            JwtUser jwtUser = UserUtil.getJwtUser();
            jwtUser.setTenant(TenantUtil.getTenant((String)tenantId));
            this.opLogRepository.saveLog(LogType.EVENT_TRACKING, "\u65e7\u7248\u591a\u79df\u6237\u65b9\u6848", (Object)jwtUser.getBuckets());
        }
    }

    public void afterProcessToken(HttpServletRequest request, HttpServletResponse response) {
        BucketContextHolder.clearContext();
        FileOpTreeContextHolder.resetContext();
    }

    public void addCustomFilter(HttpSecurity http, AuthenticationManager authenticationManager) throws Exception {
        super.addCustomFilter(http, authenticationManager);
        http.headers().cacheControl();
        http.headers().frameOptions().disable();
        if (StringUtils.hasText((String)this.frameAncestors)) {
            http.headers().contentSecurityPolicy("frame-ancestors " + this.frameAncestors);
        } else {
            http.headers().contentSecurityPolicy("frame-ancestors *.digiwincloud.com *.digiwincloud.com.cn");
        }
        http.addFilterAfter((Filter)new DapAsyncManagerIntegrationFilter(), WebAsyncManagerIntegrationFilter.class);
    }

    private void setTenantId(HttpServletRequest request, JwtUser jwtUser) {
        String accessToken = request.getHeader(GlobalConstants.HTTP_HEADER_ACCESS_TOKEN_KEY);
        if (accessToken != null && accessToken.startsWith("dmc-sdk:")) {
            jwtUser.setTenantId(accessToken.replace("dmc-sdk:", ""));
        }
    }
}

