/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.auth.domain;

import com.digiwin.dap.middleware.dmc.support.auth.domain.DriveAuth;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public class JwtGrantedAuthority
implements GrantedAuthority {
    private String role;
    private DriveAuth driveAuth;

    public JwtGrantedAuthority() {
    }

    public JwtGrantedAuthority(String role) {
        Assert.hasText((String)role, (String)"A granted authority textual representation is required");
        this.role = "ROLE_" + role;
    }

    public JwtGrantedAuthority(DriveAuth driveAuth) {
        Assert.notNull((Object)driveAuth, (String)"A granted driveAuthRequest is required");
        this.driveAuth = driveAuth;
    }

    public DriveAuth getDriveAuth() {
        return this.driveAuth;
    }

    public void setDriveAuth(DriveAuth driveAuth) {
        this.driveAuth = driveAuth;
    }

    @JsonIgnore
    public String getAuthority() {
        return this.role;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof JwtGrantedAuthority && this.role.equals(((JwtGrantedAuthority)obj).role);
    }

    public int hashCode() {
        return this.role.hashCode();
    }

    public String toString() {
        return this.role;
    }
}

