/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.auth.domain;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.LoginInfo;
import com.digiwin.dap.middleware.dmc.domain.enumeration.RoleEnum;
import com.digiwin.dap.middleware.dmc.domain.enumeration.VersionTag;
import com.digiwin.dap.middleware.dmc.entity.objectid.User;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtGrantedAuthority;
import com.digiwin.dap.middleware.dmc.util.TenantUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class JwtUser
extends AuthoredUser {
    private Boolean iam;
    private Boolean admin;
    private RoleEnum role;
    private String deployArea;
    private Set<String> buckets = new HashSet();
    @JsonIgnore
    private String password;
    @JsonIgnore
    private Collection<JwtGrantedAuthority> authorities = new ArrayList();
    @Deprecated
    private String tenant;
    @Deprecated
    private String username;
    private String version;

    private JwtUser() {
    }

    public static JwtUser anonymous() {
        JwtUser jwtUser = new JwtUser();
        jwtUser.setUserId("anonymousUser");
        jwtUser.setUserName("anonymousUser");
        jwtUser.setIam(Boolean.valueOf(false));
        jwtUser.setAdmin(Boolean.valueOf(false));
        return jwtUser;
    }

    public static JwtUser initUser(User user, String tenantId) {
        JwtUser jwtUser = new JwtUser();
        jwtUser.setUserId(user.getName());
        jwtUser.setUserName(user.getDisplayName());
        jwtUser.setTenantId(TenantUtil.getTenant((String)tenantId));
        jwtUser.setIam(Boolean.valueOf(false));
        jwtUser.initRole(user.getBuiltinRole());
        jwtUser.setVersion(VersionTag.V2.name());
        return jwtUser;
    }

    public static JwtUser initUser(LoginInfo user) {
        JwtUser jwtUser = new JwtUser();
        jwtUser.setSid(user.getSid());
        jwtUser.setUserId(user.getId());
        jwtUser.setUserName(user.getName());
        jwtUser.setTenantSid(user.getSid());
        jwtUser.setTenantId(user.getTenantId());
        jwtUser.setTenantName(user.getTenantName());
        jwtUser.setIam(Boolean.valueOf(true));
        jwtUser.initRole(RoleEnum.BucketCreator.name());
        jwtUser.getBuckets().add("MyDocument");
        return jwtUser;
    }

    private static List<JwtGrantedAuthority> getRoles(String builtinRole) {
        try {
            String[] roles = builtinRole.split(",");
            return Arrays.stream(roles).map(JwtGrantedAuthority::new).collect(Collectors.toList());
        }
        catch (Exception exception) {
            return new ArrayList<JwtGrantedAuthority>();
        }
    }

    public void initRole(String builtinRole) {
        this.setAdmin(Boolean.valueOf(RoleEnum.SysAdmin.name().equals(builtinRole)));
        this.setRole(RoleEnum.valueOf((String)builtinRole));
        this.setAuthorities((Collection)JwtUser.getRoles((String)builtinRole));
    }

    public Boolean getIam() {
        return this.iam;
    }

    public void setIam(Boolean iam) {
        this.iam = iam;
    }

    public Boolean getAdmin() {
        return this.admin;
    }

    public void setAdmin(Boolean admin) {
        this.admin = admin;
    }

    public RoleEnum getRole() {
        return this.role;
    }

    public void setRole(RoleEnum role) {
        this.role = role;
    }

    public String getTenantId() {
        return super.getTenantId();
    }

    public String getDeployArea() {
        return this.deployArea;
    }

    public void setDeployArea(String deployArea) {
        this.deployArea = deployArea;
    }

    public Set<String> getBuckets() {
        return this.buckets;
    }

    public void setBuckets(Set<String> buckets) {
        this.buckets = buckets;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Collection<JwtGrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(Collection<JwtGrantedAuthority> authorities) {
        this.authorities = authorities;
    }

    @Deprecated
    public String getTenant() {
        return this.tenant;
    }

    @Deprecated
    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JwtUser jwtUser = (JwtUser)o;
        return this.getUserId().equals(jwtUser.getUserId()) && Objects.equals(this.getTenantId(), jwtUser.getTenantId());
    }

    public int hashCode() {
        return Objects.hash(this.getUserId(), this.getTenantId());
    }

    public String uniqueKey() {
        if (this.iam.booleanValue()) {
            return String.format("iam:%s::%s", this.getUserId(), this.getTenantId() == null ? "default" : this.getTenantId());
        }
        return String.format("%s::%s", this.getUserId(), this.getTenantId() == null ? "default" : this.getTenantId());
    }
}

