/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.remote.impl;

import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.remote.cac.vo.PurchaseDetailExtVO;
import com.digiwin.dap.middleware.dmc.support.remote.CacService;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.support.DapHttpService;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CacServiceImpl
implements CacService {
    private static final Logger logger = LoggerFactory.getLogger(CacServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate restTemplate;
    @Autowired
    private DapHttpService dapHttpService;

    public PurchaseDetailExtVO findPurchaseDetail(String purchaseId) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, this.dapHttpService.getUserToken(""));
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        String url = this.envProperties.getCacUri() + "/api/cac/v4/resource/purchase/detail?purchaseId={purchaseId}";
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{purchaseId});
            return Optional.ofNullable(response.getBody()).map(StdData::getData).orElse(null);
        }
        catch (Exception e) {
            logger.error("\u3010CAC\u3011 \u67e5\u8be2\u8ba1\u91cf\u5546\u54c1\u6388\u6743\u4fe1\u606f", (Throwable)e);
            return null;
        }
    }
}

