/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.remote.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.entity.uuid.DirInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.support.remote.DmcService;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DmcServiceImpl
implements DmcService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmcServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Qualifier(value="tenantCustomRestTemplate")
    @Autowired
    private RestTemplate tenantCustomRestTemplate;

    public PageData<DirInfo> directorySearch(String bucket, Page page, String userToken, String dmcUri) {
        String url = dmcUri + String.format("/api/dmc/v2/directory/%s/search", bucket);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity request = new HttpEntity((Object)page, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (PageData)Optional.ofNullable(responseEntity.getBody()).orElseGet(StdData::new).getData();
        }
        catch (Exception e) {
            throw new BusinessException("\u3010DMC\u8c03\u7528\u3011\u67e5\u8be2\u76ee\u5f55\u4fe1\u606f[\u5206\u9875] \u5931\u8d25", (Throwable)e);
        }
    }

    public PageData<FileInfo> fileSearch(String bucket, Page page, String userToken, String dmcUri) {
        String url = dmcUri + String.format("/api/dmc/v2/fileinfo/%s/search", bucket);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity request = new HttpEntity((Object)page, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (PageData)Optional.ofNullable(responseEntity.getBody()).orElseGet(StdData::new).getData();
        }
        catch (Exception e) {
            throw new BusinessException("\u3010DMC\u8c03\u7528\u3011\u67e5\u8be2\u6587\u4ef6\u4fe1\u606f[\u5206\u9875] \u5931\u8d25", (Throwable)e);
        }
    }

    public byte[] filePreview(String bucket, String fileId, String userToken, String dmcUri) {
        String url = dmcUri + String.format("/api/dmc/v2/file/%s/preview/%s", bucket, fileId);
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.tenantCustomRestTemplate.exchange(url, HttpMethod.GET, request, byte[].class, new Object[0]);
            return (byte[])responseEntity.getBody();
        }
        catch (Exception e) {
            throw new BusinessException(CharSequenceUtil.format((CharSequence)"\u3010DMC\u8c03\u7528\u3011\u6587\u4ef6\u9884\u89c8\u5931\u8d25, bucket={}, fileId={}, dmcUri={} ", (Object[])new Object[]{bucket, fileId, dmcUri}), (Throwable)e);
        }
    }
}

