/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.remote.impl;

import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.remote.gmc.vo.GoodsVO;
import com.digiwin.dap.middleware.dmc.support.remote.GmcService;
import com.digiwin.dap.middleware.support.DapHttpService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class GmcServiceImpl
implements GmcService {
    private static final Logger logger = LoggerFactory.getLogger(GmcServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate restTemplate;
    @Autowired
    private DapHttpService dapHttpService;

    public GoodsVO findGoodsByCode(String code, String userToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        String url = this.envProperties.getGmcUri() + "/api/cloudgoods/{goodsCode}/simple";
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{code});
            return (GoodsVO)response.getBody();
        }
        catch (Exception e) {
            logger.error("\u3010GMC\u3011 \u67e5\u8be2\u5546\u54c1\u4fe1\u606f", (Throwable)e);
            return null;
        }
    }
}

