/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.remote.impl;

import com.digiwin.dap.middleware.auth.LoginInfo;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.dmc.domain.BaseVO;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.TenantVO;
import com.digiwin.dap.middleware.dmc.support.auth.domain.LoginUser;
import com.digiwin.dap.middleware.dmc.support.remote.IamService;
import com.digiwin.dap.middleware.dmc.support.remote.impl.IamServiceImpl;
import com.digiwin.dap.middleware.dmc.util.UserUtil;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.ThirdCallException;
import com.digiwin.dap.middleware.support.DapHttpService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Service
public class IamServiceImpl
implements IamService {
    private static final Logger logger = LoggerFactory.getLogger(IamServiceImpl.class);
    private static final String LOGIN = "/api/iam/v2/identity/login";
    private static final String REFRESH_TENANT = "/api/iam/v2/identity/token/refresh/tenant";
    private static final String DEV_APP = "/api/iam/v2/dev/app/simple";
    private static final String TENANT_NAME_LIST = "/api/iam/v2/tenant/getname/list";
    private static final String USER_TENANT = "/api/iam/v2/user/find/tenant";
    private static final String TENANT_APP = "/api/iam/v2/app/query";
    @Qualifier(value="dapRetryRestTemplate")
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private DapHttpService dapHttpService;

    public LoginInfo getIamUser(String userToken) {
        String url = this.envProperties.getIamUri() + "/api/iam/v2/identity/token/analyze";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            return (LoginInfo)this.restTemplate.postForObject(url, (Object)request, LoginInfo.class, new Object[0]);
        }
        catch (HttpStatusCodeException e) {
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.USER_TOKEN_INVALID, url, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.USER_TOKEN_INVALID);
        }
    }

    public String getUserToken(LoginUser loginUser) {
        String url = this.envProperties.getIamUri() + LOGIN;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_APP_TOKEN_KEY, this.envProperties.getAppToken());
            HashMap<String, String> requestContent = new HashMap<String, String>();
            requestContent.put("tenantId", loginUser.getTenantId());
            requestContent.put("userId", loginUser.getUsername());
            requestContent.put("password", loginUser.getPwdhash());
            requestContent.put("identityType", "token");
            HttpEntity request = new HttpEntity(requestContent, (MultiValueMap)headers);
            Map map = (Map)this.restTemplate.postForObject(url, (Object)request, Map.class, new Object[0]);
            return (String)map.get("token");
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.BUSINESS);
        }
    }

    public String getUserToken(String userToken, String tenantId) {
        String url = this.envProperties.getIamUri() + REFRESH_TENANT;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            headers.add(GlobalConstants.HTTP_HEADER_APP_TOKEN_KEY, this.envProperties.getAppToken());
            HashMap<String, String> requestContent = new HashMap<String, String>();
            requestContent.put("tenantId", tenantId);
            HttpEntity request = new HttpEntity(requestContent, (MultiValueMap)headers);
            Map map = (Map)this.restTemplate.postForObject(url, (Object)request, Map.class, new Object[0]);
            return (String)map.get("user_token");
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.BUSINESS, e.getMessage());
        }
    }

    public List<String> getTenantIds(String userToken) {
        ArrayList<String> tenantIds = new ArrayList<String>();
        String url = this.envProperties.getIamUri() + USER_TENANT;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            1 responseType = new /* Unavailable Anonymous Inner Class!! */;
            List tenants = (List)this.restTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)responseType, new Object[0]).getBody();
            if (tenants != null) {
                tenantIds.addAll(tenants.stream().filter(o -> "Joined".equals(o.getStatus())).map(TenantVO::getId).collect(Collectors.toList()));
            }
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.BUSINESS, e.getMessage());
        }
        return tenantIds;
    }

    public List<BaseVO> getApp() {
        try {
            String url = this.envProperties.getIamUri() + DEV_APP;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtil.isIam() ? UserUtils.getToken() : this.dapHttpService.getUserToken(""));
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            2 responseType = new /* Unavailable Anonymous Inner Class!! */;
            List result = (List)this.restTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)responseType, new Object[0]).getBody();
            if (result != null) {
                return result;
            }
        }
        catch (Exception e) {
            throw new BusinessException(CommonErrorCode.BUSINESS.getMessage(new Object[0]), (Throwable)e);
        }
        return Collections.emptyList();
    }

    public List<TenantVO> getTenantIdsBySids(Collection<Long> tenantSids) {
        String url = this.envProperties.getIamUri() + TENANT_NAME_LIST;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HttpEntity request = new HttpEntity(tenantSids, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.ofNullable(responseEntity.getBody()).orElseGet(Collections::emptyList);
        }
        catch (Exception e) {
            throw new BusinessException(CommonErrorCode.BUSINESS.getErrorMessage(), (Throwable)e);
        }
    }

    public List<String> getTenantAppId(String userToken) {
        String url = this.envProperties.getIamUri() + TENANT_APP;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            4 responseType = new /* Unavailable Anonymous Inner Class!! */;
            List apps = (List)this.restTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)responseType, new Object[0]).getBody();
            if (apps != null) {
                return apps.stream().map(AppAuthVo::getId).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            logger.warn("\u83b7\u53d6\u79df\u6237\u8d2d\u4e70\u5e94\u7528\u51fa\u9519", (Throwable)e);
        }
        return Collections.emptyList();
    }
}

