/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.remote.impl;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.producer.ProducerService;
import com.digiwin.dap.middleware.dmc.constant.MailTypeEnum;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.service.business.FileInfoStatService;
import com.digiwin.dap.middleware.dmc.support.remote.MailService;
import com.digiwin.dap.middleware.dmc.support.remote.impl.MailServiceImpl;
import com.digiwin.dap.middleware.dmc.util.DataUtil;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MailServiceImpl
implements MailService {
    public static final Integer EMAIL_TYPE_0 = 0;
    public static final Integer EMAIL_TYPE_1 = 1;
    private static final Logger logger = LoggerFactory.getLogger(MailServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private ProducerService producerService;
    @Autowired
    private FileInfoStatService fileInfoStatService;

    public void statsFull(Object data) {
        MessageBody messageVO = new MessageBody();
        messageVO.setOpType(MailTypeEnum.DMC_BUCKET_STATS_FULL.name());
        messageVO.setData(data);
        this.producerService.msg(messageVO);
    }

    public void statsInc(Object data) {
        MessageBody messageVO = new MessageBody();
        messageVO.setOpType(MailTypeEnum.DMC_BUCKET_STATS_INC.name());
        messageVO.setData(data);
        this.producerService.msg(messageVO);
    }

    public void register(Object data) {
        MessageBody messageVO = new MessageBody();
        messageVO.setOpType(MailTypeEnum.DMC_BUCKET_REGISTER.name());
        messageVO.setData(data);
        this.producerService.msg(messageVO);
    }

    public void notifyByEmail(Bucket body, Integer type) {
        block5: {
            try {
                if (body.getQuotaSize() <= 0L) break block5;
                LinkedList emails = body.getEmails();
                if (emails == null) {
                    emails = new LinkedList();
                }
                NoticeMessageVO noticeMessageVO = new NoticeMessageVO(null);
                noticeMessageVO.setCode(body.getAppId());
                noticeMessageVO.setName(body.getName());
                noticeMessageVO.setSizeLimit(DataUtil.byteSwitch((long)body.getQuotaSize()));
                noticeMessageVO.setDeployArea(this.envProperties.getDeployArea());
                noticeMessageVO.setStaticContacts(String.join((CharSequence)";", emails));
                if (EMAIL_TYPE_0.equals(type)) {
                    long cur = this.fileInfoStatService.fileStats(body.getName()).getSize();
                    noticeMessageVO.setCur(DataUtil.byteSwitch((long)cur));
                    MessageBody messageVO = new MessageBody();
                    messageVO.setOpType(MailTypeEnum.DMC_BUCKET_LIMIT_EMAIL_0_OPS.name());
                    messageVO.setData((Object)noticeMessageVO);
                    logger.info("0:{}", (Object)JsonUtils.objToJson((Object)messageVO));
                    this.producerService.msg(messageVO);
                    break block5;
                }
                if (EMAIL_TYPE_1.equals(type)) {
                    MessageBody messageVO = new MessageBody();
                    messageVO.setOpType(MailTypeEnum.DMC_BUCKET_LIMIT_EMAIL_1.name());
                    messageVO.setData((Object)noticeMessageVO);
                    logger.info("1:{}", (Object)JsonUtils.objToJson((Object)messageVO));
                    this.producerService.msg(messageVO);
                    break block5;
                }
                return;
            }
            catch (Exception e) {
                logger.warn("bucket\u90ae\u4ef6\u901a\u77e5\u51fa\u9519", (Throwable)e);
            }
        }
    }
}

