/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.schedule.impl;

import com.digiwin.dap.middleware.dmc.domain.v2.BucketStats;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.Stats;
import com.digiwin.dap.middleware.dmc.entity.objectid.Task;
import com.digiwin.dap.middleware.dmc.repository.StatsRepository;
import com.digiwin.dap.middleware.dmc.repository.TaskRepository;
import com.digiwin.dap.middleware.dmc.repository.UserRepository;
import com.digiwin.dap.middleware.dmc.support.schedule.ScheduleService;
import com.digiwin.dap.middleware.dmc.support.schedule.TaskIdEnum;
import java.time.LocalDate;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BucketStatsTask
implements ScheduleService {
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private StatsRepository statsRepository;

    public String execute() {
        Task task = this.taskRepository.findValidTaskByCode(TaskIdEnum.TS001.name());
        if (task != null) {
            LocalDate now = LocalDate.now();
            this.statsRepository.deleteByYearMonth(now.getYear(), now.getMonthValue());
            List bucketsStats = this.statsRepository.getBucketStats();
            Stats stats = new Stats();
            stats.setYear(Integer.valueOf(now.getYear()));
            stats.setMonth(Integer.valueOf(now.getMonthValue()));
            stats.setTotalSize(Long.valueOf(bucketsStats.stream().mapToLong(BucketStats::getTotalSize).sum()));
            stats.setTotalCount(Long.valueOf(bucketsStats.stream().mapToLong(BucketStats::getTotalCount).sum()));
            stats.setFileSize(Long.valueOf(bucketsStats.stream().mapToLong(BucketStats::getFileSize).sum()));
            stats.setFileCount(Long.valueOf(bucketsStats.stream().mapToLong(BucketStats::getFileCount).sum()));
            stats.setBucketCount(Integer.valueOf(bucketsStats.size()));
            stats.setUserCount(Integer.valueOf(this.userRepository.findAll().size()));
            stats.setBuckets(bucketsStats);
            this.statsRepository.insert((ObIdEntity)stats);
            return String.format("\u7edf\u8ba1Bucket\uff1a%s\u4e2a", bucketsStats.size());
        }
        return null;
    }
}

