/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.schedule.impl;

import com.digiwin.dap.middleware.dmc.entity.objectid.Task;
import com.digiwin.dap.middleware.dmc.repository.StatsRepository;
import com.digiwin.dap.middleware.dmc.repository.TaskRepository;
import com.digiwin.dap.middleware.dmc.support.remote.MailService;
import com.digiwin.dap.middleware.dmc.support.schedule.ScheduleService;
import com.digiwin.dap.middleware.dmc.support.schedule.TaskIdEnum;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailBucketIncrementTask
implements ScheduleService {
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("yyyy-MM");
    @Autowired
    private MailService mailService;
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    private StatsRepository statsRepository;

    public String execute() {
        Task task = this.taskRepository.findValidTaskByCode(TaskIdEnum.TS007.name());
        if (task != null) {
            LocalDate prev = LocalDate.now().minusMonths(task.getPeriod().intValue());
            LocalDate next = LocalDate.now().minusMonths(1L);
            List buckets = this.statsRepository.getBucketInc(prev, next);
            String prevStr = DTF.format(prev);
            String nextStr = DTF.format(next);
            HashMap<String, Object> mail = new HashMap<String, Object>();
            mail.put("prev", prevStr);
            mail.put("next", nextStr);
            mail.put("buckets", buckets);
            this.mailService.statsInc(mail);
            return String.format("%s~%s \u90ae\u4ef6\u53d1\u9001\u6210\u529f", prevStr, nextStr);
        }
        return null;
    }
}

