/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.schedule.impl;

import com.digiwin.dap.middleware.dmc.domain.v2.BucketStats;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.objectid.Stats;
import com.digiwin.dap.middleware.dmc.entity.objectid.Task;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.repository.StatsRepository;
import com.digiwin.dap.middleware.dmc.repository.TaskRepository;
import com.digiwin.dap.middleware.dmc.support.remote.MailService;
import com.digiwin.dap.middleware.dmc.support.schedule.ScheduleService;
import com.digiwin.dap.middleware.dmc.support.schedule.TaskIdEnum;
import com.digiwin.dap.middleware.dmc.util.DataUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailBucketTotalTask
implements ScheduleService {
    @Autowired
    private MailService mailService;
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    private StatsRepository statsRepository;
    @Autowired
    private BucketRepository bucketRepository;

    public String execute() {
        Task task = this.taskRepository.findValidTaskByCode(TaskIdEnum.TS006.name());
        if (task != null) {
            Stats stats = this.statsRepository.findByYearMonth(LocalDate.now().getYear(), LocalDate.now().getMonthValue());
            List buckets = this.bucketRepository.findAll();
            Map<String, Long> bucketMap = buckets.stream().collect(Collectors.toMap(Bucket::getName, Bucket::getQuotaSize));
            HashMap<String, Serializable> data = new HashMap<String, Serializable>();
            ArrayList bucketDetail = new ArrayList();
            data.put("year", stats.getYear());
            data.put("month", stats.getMonth());
            data.put("totalSize", DataUtil.byte2Gb((long)stats.getTotalSize()));
            data.put("quotaSize", DataUtil.byte2Gb((long)buckets.stream().mapToLong(Bucket::getQuotaSize).sum()));
            data.put("buckets", bucketDetail);
            for (BucketStats bucket : stats.getBuckets()) {
                HashMap<String, Object> temp = new HashMap<String, Object>();
                temp.put("name", bucket.getName());
                temp.put("totalSize", DataUtil.byte2Gb((long)bucket.getTotalSize()));
                temp.put("quotaSize", DataUtil.byte2Gb((long)bucketMap.getOrDefault(bucket.getName(), 0L)));
                bucketDetail.add(temp);
            }
            this.mailService.statsFull(data);
            return "\u90ae\u4ef6\u53d1\u9001\u6210\u529f";
        }
        return null;
    }
}

