/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.schedule.impl;

import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.entity.objectid.Task;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.repository.TaskRepository;
import com.digiwin.dap.middleware.dmc.service.business.FileRecycleService;
import com.digiwin.dap.middleware.dmc.support.schedule.ScheduleService;
import com.digiwin.dap.middleware.dmc.support.schedule.TaskIdEnum;
import com.mongodb.client.model.Filters;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileExpiredToRecycleBinTask
implements ScheduleService {
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private FileRecycleService fileRecycleService;

    public String execute() {
        Task task = this.taskRepository.findValidTaskByCode(TaskIdEnum.TS008.name());
        if (task != null) {
            Bson filter = Filters.lt((String)"expireDate", (Object)LocalDateTime.now());
            List buckets = this.bucketRepository.findAll();
            ArrayList results = new ArrayList();
            buckets.forEach(bucket -> {
                List fileInfos = this.fileNodeService.findByCondition(bucket.getName(), filter);
                fileInfos.forEach(fileInfo -> this.fileRecycleService.removeFile(bucket.getName(), fileInfo.getId()));
                if (!fileInfos.isEmpty()) {
                    results.add(String.format("%s: %s", bucket.getName(), fileInfos.size()));
                }
            });
            return ((Object)results).toString();
        }
        return null;
    }
}

