/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.schedule.impl;

import com.digiwin.dap.middleware.dmc.dao.RecycleCrudService;
import com.digiwin.dap.middleware.dmc.entity.objectid.Task;
import com.digiwin.dap.middleware.dmc.entity.uuid.RecycleBin;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.repository.TaskRepository;
import com.digiwin.dap.middleware.dmc.service.business.FileRecycleService;
import com.digiwin.dap.middleware.dmc.support.schedule.ScheduleService;
import com.digiwin.dap.middleware.dmc.support.schedule.TaskIdEnum;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileRecycleBinToDeleteTask
implements ScheduleService {
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private RecycleCrudService recycleCrudService;
    @Autowired
    private FileRecycleService fileRecycleService;

    public String execute() {
        Task task = this.taskRepository.findValidTaskByCode(TaskIdEnum.TS011.name());
        if (task != null) {
            List buckets = this.bucketRepository.findAll();
            ArrayList results = new ArrayList();
            buckets.forEach(bucket -> {
                LocalDateTime deleteDate = bucket.getRetain() != null && bucket.getRetain() > 0 ? LocalDateTime.now().minusDays(bucket.getRetain().intValue()) : LocalDateTime.now().minusMonths(task.getPeriod().intValue());
                List recycleBins = this.recycleCrudService.findLtDeleteDate(bucket.getName(), deleteDate);
                for (RecycleBin recyclebin : recycleBins) {
                    this.fileRecycleService.deleteRecycleBin(bucket.getName(), recyclebin.getId());
                }
                if (!recycleBins.isEmpty()) {
                    results.add(String.format("%s: %s", bucket.getName(), recycleBins.size()));
                }
            });
            return ((Object)results).toString();
        }
        return null;
    }
}

