/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.schedule.impl;

import com.digiwin.dap.middleware.dmc.domain.v2.FileStats;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.Stats;
import com.digiwin.dap.middleware.dmc.entity.objectid.Task;
import com.digiwin.dap.middleware.dmc.repository.StatsRepository;
import com.digiwin.dap.middleware.dmc.repository.TaskRepository;
import com.digiwin.dap.middleware.dmc.service.business.FileInfoStatService;
import com.digiwin.dap.middleware.dmc.support.schedule.ScheduleService;
import com.digiwin.dap.middleware.dmc.support.schedule.TaskIdEnum;
import java.time.LocalDate;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileStatsTask
implements ScheduleService {
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    private StatsRepository statsRepository;
    @Autowired
    private FileInfoStatService fileInfoStatService;

    public String execute() {
        Task task = this.taskRepository.findValidTaskByCode(TaskIdEnum.TS002.name());
        if (task != null) {
            Stats stats = this.statsRepository.findByYearMonth(LocalDate.now().getYear(), LocalDate.now().getMonthValue());
            if (stats == null) {
                return null;
            }
            stats.getBuckets().forEach(bucket -> {
                ArrayList fileStats = new ArrayList();
                FileStats.defaults.values().forEach(value -> {
                    FileStats temp = new FileStats(value.getStart(), value.getEnd());
                    temp.setCount(this.fileInfoStatService.countByRange(bucket.getName(), value.getStart(), value.getEnd()));
                    fileStats.add(temp);
                });
                bucket.setFileStats(fileStats);
            });
            this.statsRepository.update((ObIdEntity)stats);
            return String.format("\u7edf\u8ba1Bucket\uff1a%s\u4e2a", stats.getBuckets().size());
        }
        return null;
    }
}

