/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.schedule.impl;

import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.objectid.Task;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.repository.TaskRepository;
import com.digiwin.dap.middleware.dmc.storage.FileStorage;
import com.digiwin.dap.middleware.dmc.storage.FileStorageFactory;
import com.digiwin.dap.middleware.dmc.support.HashingUploadWrapper;
import com.digiwin.dap.middleware.dmc.support.schedule.ScheduleService;
import com.digiwin.dap.middleware.dmc.support.schedule.TaskIdEnum;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.List;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RefreshHashTask
implements ScheduleService {
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private FileStorageFactory fileStorageFactory;

    public String execute() {
        Task task = this.taskRepository.findValidTaskByCode(TaskIdEnum.TS015.name());
        if (task != null) {
            Bson filter = Filters.eq((String)"hash", null);
            List buckets = this.bucketRepository.findAll();
            ArrayList results = new ArrayList();
            buckets.stream().filter(Bucket::isHash).forEach(bucket -> {
                List fileInfos;
                ArrayList errorIds = new ArrayList();
                while (!(fileInfos = this.fileNodeService.findByCondition(bucket.getName(), filter, null, null, 0, 1000)).isEmpty()) {
                    fileInfos.forEach(fileInfo -> {
                        try {
                            FileStorage fileStorage = this.fileStorageFactory.getFileStorage(bucket.getName(), fileInfo);
                            HashingUploadWrapper.of((boolean)true).uploadFromStream(fileStorage, fileInfo);
                            this.fileNodeService.replace((UuIdEntity)fileInfo);
                        }
                        catch (Exception e) {
                            errorIds.add(fileInfo.getId());
                            logger.error("\u5f02\u5e38\u6587\u4ef6ID\uff1a{}", (Object)fileInfo.getId(), (Object)e);
                            fileInfo.setHash("");
                            this.fileNodeService.replace((UuIdEntity)fileInfo);
                        }
                    });
                }
                if (!errorIds.isEmpty()) {
                    results.add(String.format("%s: %s", bucket.getName(), errorIds));
                }
            });
            return "\u5931\u8d25\u4fe1\u606f\uff1a" + results;
        }
        return null;
    }
}

