/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.schedule.impl;

import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.Task;
import com.digiwin.dap.middleware.dmc.entity.objectid.TaskLog;
import com.digiwin.dap.middleware.dmc.repository.TaskLogRepository;
import com.digiwin.dap.middleware.dmc.repository.TaskRepository;
import com.digiwin.dap.middleware.dmc.support.schedule.ScheduleService;
import com.digiwin.dap.middleware.dmc.support.schedule.TaskManagerService;
import java.beans.Introspector;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;

@Service
public class TaskManagerServiceImpl
implements TaskManagerService {
    private static final Logger logger = LoggerFactory.getLogger(TaskManagerServiceImpl.class);
    private static final int SLEEP_MILLIS = 30000;
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<String, ScheduleService> scheduledTaskMap = new ConcurrentHashMap();
    private final Map<String, ScheduledFuture<?>> scheduledFutureMap = new ConcurrentHashMap();
    @Autowired
    private ApplicationContext context;
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    private TaskLogRepository taskLogRepository;
    @Autowired
    private ThreadPoolTaskScheduler taskScheduler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(String taskCode) {
        this.lock.lock();
        try {
            Task task;
            if (!this.isStart(taskCode) && (task = this.taskRepository.findValidTaskByCode(taskCode)) != null && this.addTask(task)) {
                this.doStartTask(task);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    public boolean stop(String taskCode) {
        boolean startFlag = this.scheduledFutureMap.containsKey(taskCode);
        if (startFlag) {
            ScheduledFuture scheduledFuture = (ScheduledFuture)this.scheduledFutureMap.get(taskCode);
            scheduledFuture.cancel(true);
        }
        this.scheduledTaskMap.remove(taskCode);
        return startFlag;
    }

    public boolean restart(String taskCode) {
        this.stop(taskCode);
        return this.start(taskCode);
    }

    public void refresh() {
        this.scheduledTaskMap.clear();
        for (Task task : this.taskRepository.findAll()) {
            if (task.getDisable().booleanValue()) continue;
            try {
                Class<?> clazz = Class.forName(task.getClassName());
                Object target = this.context.getBean(clazz);
                if (target.getClass() == null || !ScheduleService.class.isAssignableFrom(target.getClass())) continue;
                this.restart(task.getCode());
            }
            catch (Exception e) {
                logger.error("[" + task.getCode() + "]\u5b9e\u73b0\u7c7b\u52a0\u8f7d\u9519\u8bef" + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTask(String className) {
        Task task = this.taskRepository.findByClassName(className);
        boolean lock = this.taskRepository.lock(task.getId());
        if (lock) {
            TaskLog taskLog = new TaskLog();
            try {
                if (task.getDisable().booleanValue()) {
                    return;
                }
                String shortClassName = ClassUtils.getShortName((String)className);
                ScheduleService scheduleService = (ScheduleService)this.context.getBean(Introspector.decapitalize(shortClassName), ScheduleService.class);
                taskLog.setTaskId(task.getId());
                taskLog.setTaskCode(task.getCode());
                taskLog.setCron(task.getCron());
                taskLog.setTriggerTime(LocalDateTime.now());
                String result = scheduleService.execute();
                taskLog.setStatus(Integer.valueOf(1));
                taskLog.setExecTime(Long.valueOf(ChronoUnit.MILLIS.between(taskLog.getTriggerTime(), LocalDateTime.now())));
                taskLog.setMessage(result);
                this.taskLogRepository.insert((ObIdEntity)taskLog);
                Thread.sleep(30000L);
            }
            catch (Exception e) {
                taskLog.setStatus(Integer.valueOf(0));
                taskLog.setMessage(e.getMessage());
                this.taskLogRepository.insert((ObIdEntity)taskLog);
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.taskRepository.unlock(task.getId());
            }
        }
    }

    private void doStartTask(Task task) {
        ScheduleService taskService = (ScheduleService)this.scheduledTaskMap.get(task.getCode());
        ScheduledFuture scheduledFuture = this.taskScheduler.schedule((Runnable)taskService, triggerContext -> new CronTrigger(task.getCron()).nextExecutionTime(triggerContext));
        this.scheduledFutureMap.put(task.getCode(), scheduledFuture);
    }

    private boolean isStart(String taskKey) {
        if (this.scheduledFutureMap.containsKey(taskKey)) {
            return !((ScheduledFuture)this.scheduledFutureMap.get(taskKey)).isCancelled();
        }
        return false;
    }

    private boolean addTask(Task task) {
        try {
            ScheduleService target = (ScheduleService)this.context.getBean(Class.forName(task.getClassName()));
            this.scheduledTaskMap.put(task.getCode(), target);
        }
        catch (ClassNotFoundException e) {
            logger.error("\u6dfb\u52a0\u4efb\u52a1\u5931\u8d25 {}", (Object)e.getMessage());
            return false;
        }
        return true;
    }
}

