/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.schedule.impl;

import com.digiwin.dap.middleware.dmc.entity.objectid.Task;
import com.digiwin.dap.middleware.dmc.repository.StatsDiskLogRepository;
import com.digiwin.dap.middleware.dmc.repository.StatsVisitLogRepository;
import com.digiwin.dap.middleware.dmc.repository.TaskRepository;
import com.digiwin.dap.middleware.dmc.support.schedule.ScheduleService;
import com.digiwin.dap.middleware.dmc.support.schedule.TaskIdEnum;
import java.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UnifiedLogCleanTask
implements ScheduleService {
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    private StatsDiskLogRepository statsDiskLogRepository;
    @Autowired
    private StatsVisitLogRepository statsVisitLogRepository;

    public String execute() {
        Task task = this.taskRepository.findValidTaskByCode(TaskIdEnum.TS010.name());
        if (task != null) {
            LocalDate now = LocalDate.now();
            long visitCount = this.statsVisitLogRepository.deleteByCreateDate(now.minusDays(10L));
            long diskCount = this.statsDiskLogRepository.deleteByCreateDate(now.minusYears(2L));
            return String.format("\u5220\u9664\u8bbf\u95ee\u65e5\u5fd7\uff1a%s\u6761\uff0c\u64cd\u4f5c\u65e5\u5fd7\uff1a%s\u6761", visitCount, diskCount);
        }
        return null;
    }
}

