/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.security;

import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.RSA;
import com.digiwin.dap.middleware.commons.crypto.constant.KeySizeEnum;
import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.support.security.DownloadResponseEncryptor;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RSAAESDownloadResponseEncryptor
extends DownloadResponseEncryptor {
    private static final Logger logger = LoggerFactory.getLogger(RSAAESDownloadResponseEncryptor.class);

    public RSAAESDownloadResponseEncryptor(byte[] plaintext, HttpServletRequest request, HttpServletResponse response) {
        super(plaintext, request, response);
    }

    public byte[] encrypt() {
        byte[] content;
        boolean dmcSecurity = Boolean.parseBoolean(this.request.getHeader("digi-middleware-security"));
        String publicKey = this.request.getHeader("digi-middleware-public-key");
        if (dmcSecurity && !StringUtils.hasLength((String)publicKey)) {
            throw new BusinessException("publicKey\u4e3a\u7a7a!");
        }
        if (dmcSecurity) {
            byte[] aesKey = AES.generateKey((int)KeySizeEnum.AES_256.getValue());
            String digitalEnvelope = Base64.encode((byte[])RSA.encryptOAEP((byte[])aesKey, (String)publicKey));
            content = AES.encryptIvCBC((byte[])this.plaintext, (byte[])aesKey);
            this.response.setHeader("digi-middleware-security", String.valueOf(true));
            this.response.setHeader("digi-middleware-digital-envelope", digitalEnvelope);
        } else {
            content = this.plaintext;
        }
        this.response.setHeader("Content-Length", String.valueOf(content.length));
        this.response.setHeader("ContentLength", String.valueOf(content.length));
        try {
            this.response.getOutputStream().write(content);
            this.response.getOutputStream().flush();
            this.response.getOutputStream().close();
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_DOWNLOAD_FAIL);
        }
        return content;
    }
}

