/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.stream;

import com.digiwin.dap.middle.stream.consumer.ConsumerService;
import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.dmc.domain.remote.cac.vo.GoodsResourceVO;
import com.digiwin.dap.middleware.dmc.domain.remote.cac.vo.PurchaseDetailExtVO;
import com.digiwin.dap.middleware.dmc.service.resource.goods.ResourceGoodsBizService;
import com.digiwin.dap.middleware.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Service;

@Service
public class ConsumerServiceImpl
implements ConsumerService {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerServiceImpl.class);
    @Autowired
    private ResourceGoodsBizService resourceGoodsBizService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @StreamListener(target="InternalInput", condition="headers['tag']=='dmcResourceGoodsPurchase'")
    public void receiveDmcResourceGoodsPurchase(Message<String> message) {
        try {
            logger.info("receive dmc resource goods purchase");
            MessageBody messageBody = (MessageBody)JsonUtils.jsonToObj((String)((String)message.getPayload()), MessageBody.class);
            PurchaseDetailExtVO purchaseDetailExtVO = (PurchaseDetailExtVO)JsonUtils.jsonToObj((String)JsonUtils.objToJson((Object)messageBody.getData()), PurchaseDetailExtVO.class);
            this.resourceGoodsBizService.saveResourceGoodsPurchaseRecord(purchaseDetailExtVO, messageBody.getUserToken());
        }
        catch (Exception e) {
            logger.error("Consume finished with exception", (Throwable)e);
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @StreamListener(target="InternalInput", condition="headers['tag']=='resourceGoods'")
    public void receiveResourceGoods(Message<String> message) {
        try {
            logger.info("receive resource goods purchase");
            MessageBody messageBody = (MessageBody)JsonUtils.jsonToObj((String)((String)message.getPayload()), MessageBody.class);
            GoodsResourceVO goodsResourceVO = (GoodsResourceVO)JsonUtils.jsonToObj((String)JsonUtils.objToJson((Object)messageBody.getData()), GoodsResourceVO.class);
            this.resourceGoodsBizService.updateResourceGoods(goodsResourceVO.getGoodsCode(), goodsResourceVO.getResourceCodes(), messageBody.getUserToken());
        }
        catch (Exception e) {
            logger.error("Consume finished with exception", (Throwable)e);
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
    }
}

