/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.upgrade;

import com.digiwin.dap.middleware.service.UpdateDatabaseService;
import com.digiwin.dap.middleware.support.upgrade.UpgradeHandler;
import com.digiwin.dap.middleware.support.upgrade.UpgradeVO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class DmcUpgradeHandler
implements UpgradeHandler {
    private final List<UpdateDatabaseService> updateDatabaseServices;

    public DmcUpgradeHandler(List<UpdateDatabaseService> updateDatabaseServices) {
        this.updateDatabaseServices = updateDatabaseServices;
    }

    public List<Object> upgrade(String startVersion, String endVersion) {
        ArrayList<Object> upgrades = new ArrayList<Object>();
        for (UpdateDatabaseService currentService : this.updateDatabaseServices) {
            if (!currentService.support(startVersion, endVersion)) continue;
            long startTime = System.currentTimeMillis();
            currentService.before();
            currentService.update();
            currentService.after();
            long upgradeTime = System.currentTimeMillis() - startTime;
            upgrades.add(new UpgradeVO(Long.valueOf(upgradeTime), currentService.version(), currentService.getClass().getName()));
        }
        return upgrades;
    }
}

