/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.support.upgrade.impl;

import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.RSA;
import com.digiwin.dap.middleware.commons.crypto.constant.KeySizeEnum;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.service.UpdateDatabaseService;
import java.security.KeyPair;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Order(value=43607)
@Service
public class UpgradeDatabaseV4366ToV4367Service
implements UpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV4366ToV4367Service.class);
    @Autowired
    protected MongoTemplate mongoTemplate;

    public String version() {
        return "4.36.7.0";
    }

    public void update() {
        logger.info("4367\u6570\u636e\u5347\u7ea7\u5f00\u59cb--->>>");
        List bucketList = this.mongoTemplate.findAll(Bucket.class);
        if (CollectionUtils.isEmpty((Collection)bucketList)) {
            return;
        }
        for (Bucket bucket : bucketList) {
            KeyPair keyPair = RSA.generateKeyPair((int)KeySizeEnum.RSA_1024.getValue());
            String publicKey = Base64.encode((byte[])keyPair.getPublic().getEncoded());
            String privateKey = Base64.encode((byte[])keyPair.getPrivate().getEncoded());
            String aesKey = Base64.encode((byte[])AES.generateKey((int)KeySizeEnum.AES_256.getValue()));
            Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)bucket.getId()));
            Update update = Update.update((String)"publicKey", (Object)publicKey).set("privateKey", (Object)privateKey).set("aesKey", (Object)aesKey).set("encryptedStorage", (Object)false);
            this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, Bucket.class);
        }
        logger.info("<<<---4367\u6570\u636e\u5347\u7ea7\u5b8c\u6210");
    }
}

