/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.util;

import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.BeanWrapperImpl;

public class BeanUtil {
    private static final Map<Class<?>, Object> DEFAULT_TYPE_VALUES;

    public static String[] getNullOrZero(Object source) {
        BeanWrapperImpl bw = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = bw.getPropertyDescriptors();
        HashSet<String> nullFields = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object obj = bw.getPropertyValue(pd.getName());
            if (!Objects.equals(DEFAULT_TYPE_VALUES.get(pd.getPropertyType()), obj)) continue;
            nullFields.add(pd.getName());
        }
        return nullFields.toArray(new String[0]);
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>> values = new HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>>();
        values.put(Boolean.TYPE, Boolean.valueOf(false));
        values.put(Byte.TYPE, Byte.valueOf((byte)0));
        values.put(Short.TYPE, Short.valueOf((short)0));
        values.put(Integer.TYPE, Integer.valueOf(0));
        values.put(Long.TYPE, Long.valueOf(0L));
        values.put(Float.TYPE, Float.valueOf(0.0f));
        values.put(Double.TYPE, Double.valueOf(0.0));
        values.put(Character.TYPE, Character.valueOf('\u0000'));
        DEFAULT_TYPE_VALUES = Collections.unmodifiableMap(values);
    }
}

