/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.util;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.dmc.constant.BaseField;
import com.digiwin.dap.middleware.dmc.constant.I18nCode;
import com.digiwin.dap.middleware.dmc.entity.uuid.DirInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.obsolete.domain.query.FileTypeEnum;
import com.digiwin.dap.middleware.dmc.util.FileUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.ansj.domain.Result;
import org.ansj.splitWord.analysis.ToAnalysis;
import org.bson.Document;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileUtil {
    private static final String ONE_SPACE = " ";

    public static String getExtension(FileInfo fileInfo) {
        String extension = fileInfo.getExtension();
        if (StringUtils.hasText((String)extension)) {
            return FileUtil.trimExtension((String)fileInfo.getExtension());
        }
        return FileUtil.getExtension((String)fileInfo.getFileName());
    }

    public static String trimExtension(String extension) {
        if (StrUtils.isEmpty((String)extension)) {
            return null;
        }
        String trimmed = extension.trim();
        String result = trimmed.replaceAll("^\\.+|\\.+$", "");
        return result.toLowerCase();
    }

    public static String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        if (!fileName.contains(".")) {
            return null;
        }
        String extension = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (extension.isEmpty()) {
            return null;
        }
        return extension.toLowerCase();
    }

    public static String getBaseName(String fileName) {
        if (fileName == null) {
            return null;
        }
        if (!fileName.contains(".")) {
            return fileName;
        }
        String baseName = fileName.substring(0, fileName.lastIndexOf("."));
        if (baseName.isEmpty()) {
            return null;
        }
        return baseName;
    }

    public static String getDupName(Map<String, Integer> names, String fileName) {
        if (names.containsKey(fileName)) {
            Integer index = names.get(fileName) + 1;
            String fileExt = FileUtil.getExtension((String)fileName);
            String fileNameNoExt = FileUtil.getBaseName((String)fileName);
            names.put(fileName, index);
            return fileNameNoExt + '.' + index + '.' + fileExt;
        }
        names.put(fileName, 0);
        return fileName;
    }

    public static String getPaths(UUID dirId, List<DirInfo> dirInfos, boolean root) {
        if (BaseField.EMPTY_UUID.equals(dirId)) {
            return root ? "/" : "";
        }
        Optional<DirInfo> optional = dirInfos.stream().filter(o -> o.getId().equals(dirId)).findFirst();
        if (optional.isPresent()) {
            DirInfo dirInfo = optional.get();
            return FileUtil.getPaths((UUID)dirInfo.getParentId(), dirInfos, (boolean)false) + "/" + dirInfo.getName();
        }
        return "/" + I18nCode.DMC_DIR_ROOT.getMessage();
    }

    public static String getContentType(String fileName) {
        return MediaTypeFactory.getMediaType((String)fileName).orElse(MediaType.APPLICATION_OCTET_STREAM).toString();
    }

    public static String getFullText(FileInfo fileInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(fileInfo.getFileName() == null ? "" : fileInfo.getFileName());
        stringBuilder.append(" ");
        stringBuilder.append(fileInfo.getDisplayName() == null ? "" : fileInfo.getDisplayName());
        stringBuilder.append(" ");
        stringBuilder.append(fileInfo.getDescription() == null ? "" : fileInfo.getDescription());
        stringBuilder.append(" ");
        stringBuilder.append(fileInfo.getTag() == null ? "" : fileInfo.getTag());
        stringBuilder.append(" ");
        Document metadata = fileInfo.getMetadata();
        stringBuilder = FileUtil.recursiveTraversal((Map)metadata, (StringBuilder)stringBuilder);
        String seg = FileUtil.getSegmentation((String)stringBuilder.toString());
        String strChinese = FileUtil.getChinese((String)stringBuilder.toString());
        StringBuilder result = new StringBuilder();
        result.append(FileUtil.getPingYin((String)seg));
        result.append(" ");
        result.append(FileUtil.getPingYin((String)strChinese));
        return result.toString();
    }

    private static StringBuilder recursiveTraversal(Map map, StringBuilder stringBuilder) {
        for (Object key : map.keySet()) {
            if (map.get(key) instanceof Map) {
                FileUtil.recursiveTraversal((Map)((Map)map.get(key)), (StringBuilder)stringBuilder);
                continue;
            }
            stringBuilder.append((Object)(map.get(key) == null ? "" : map.get(key)));
            stringBuilder.append(" ");
        }
        return stringBuilder;
    }

    public static String getPingYin(String text) {
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        format.setVCharType(HanyuPinyinVCharType.WITH_U_UNICODE);
        format.setToneType(HanyuPinyinToneType.WITH_TONE_NUMBER);
        char[] input = text.trim().toCharArray();
        StringBuilder output = new StringBuilder();
        try {
            for (char anInput : input) {
                if (Character.toString(anInput).matches("[\\u4E00-\\u9FA5]+")) {
                    String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)anInput, (HanyuPinyinOutputFormat)format);
                    output.append(temp[0]);
                    continue;
                }
                output.append(Character.toString(anInput));
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return output.toString();
    }

    public static String getSegmentation(String text) {
        Result parse = ToAnalysis.parse((String)text);
        return parse.toStringWithOutNature(" ");
    }

    public static String getChinese(String text) {
        String reg = "([\u4e00-\u9fa5]+)";
        String str = "";
        Matcher matcher = Pattern.compile(reg).matcher(text);
        while (matcher.find()) {
            str = str + matcher.group(0);
        }
        int length = str.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            stringBuilder.append(str.charAt(i));
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static List<String> getFileType(FileTypeEnum type) {
        switch (1.$SwitchMap$com$digiwin$dap$middleware$dmc$obsolete$domain$query$FileTypeEnum[type.ordinal()]) {
            case 1: {
                return FileUtil.getTextExtensions();
            }
            case 2: {
                return FileUtil.getPictureExtensions();
            }
            case 3: {
                return FileUtil.getAudioExtensions();
            }
            case 4: {
                return FileUtil.getVideoExtensions();
            }
        }
        return null;
    }

    public static List<String> getFileTypeOften(FileTypeEnum type) {
        switch (1.$SwitchMap$com$digiwin$dap$middleware$dmc$obsolete$domain$query$FileTypeEnum[type.ordinal()]) {
            case 1: {
                return FileUtil.getTextOften();
            }
            case 2: {
                return FileUtil.getPictureOften();
            }
            case 3: {
                return FileUtil.getAudioOften();
            }
            case 4: {
                return FileUtil.getVideoOften();
            }
        }
        return null;
    }

    public static List<String> getAllTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.addAll(FileUtil.getTextExtensions());
        types.addAll(FileUtil.getPictureExtensions());
        types.addAll(FileUtil.getAudioExtensions());
        types.addAll(FileUtil.getVideoExtensions());
        return types;
    }

    public static List<String> getFileTypeOther(FileTypeEnum type) {
        List<String> types = new ArrayList<String>();
        switch (1.$SwitchMap$com$digiwin$dap$middleware$dmc$obsolete$domain$query$FileTypeEnum[type.ordinal()]) {
            case 1: {
                types = FileUtil.getTextExtensions();
                types.removeAll(FileUtil.getFullTypes((List)FileUtil.getTextOften()));
                break;
            }
            case 2: {
                types = FileUtil.getPictureExtensions();
                types.removeAll(FileUtil.getPictureOften());
                break;
            }
            case 3: {
                types = FileUtil.getAudioExtensions();
                types.removeAll(FileUtil.getAudioOften());
                break;
            }
            case 4: {
                types = FileUtil.getVideoExtensions();
                types.removeAll(FileUtil.getVideoOften());
                break;
            }
        }
        return types;
    }

    public static List<String> getTextExtensions() {
        ArrayList<String> textExtentions = new ArrayList<String>();
        textExtentions.add("ddb");
        textExtentions.add("doc");
        textExtentions.add("txt");
        textExtentions.add("wps");
        textExtentions.add("xls");
        textExtentions.add("ppt");
        textExtentions.add("htm");
        textExtentions.add("html");
        textExtentions.add("pdf");
        textExtentions.add("dwg");
        textExtentions.add("docx");
        textExtentions.add("pptx");
        textExtentions.add("xlsx");
        return textExtentions;
    }

    public static List<String> getPictureExtensions() {
        ArrayList<String> pictureExtentions = new ArrayList<String>();
        pictureExtentions.add("bmp");
        pictureExtentions.add("jpg");
        pictureExtentions.add("jpeg");
        pictureExtentions.add("png");
        pictureExtentions.add("pcx");
        pictureExtentions.add("tiff");
        pictureExtentions.add("tga");
        pictureExtentions.add("exif");
        pictureExtentions.add("fpx");
        pictureExtentions.add("svg");
        pictureExtentions.add("psd");
        pictureExtentions.add("cdr");
        pictureExtentions.add("gif");
        pictureExtentions.add("dxf");
        pictureExtentions.add("qti");
        pictureExtentions.add("qtf");
        pictureExtentions.add("tif");
        pictureExtentions.add("wmf");
        pictureExtentions.add("emf");
        pictureExtentions.add("lic");
        pictureExtentions.add("eps");
        pictureExtentions.add("gif");
        return pictureExtentions;
    }

    public static List<String> getAudioExtensions() {
        ArrayList<String> audioExtentions = new ArrayList<String>();
        audioExtentions.add("wav");
        audioExtentions.add("mp3");
        audioExtentions.add("ra");
        audioExtentions.add("rma");
        audioExtentions.add("wma");
        audioExtentions.add("asf");
        audioExtentions.add("mid");
        audioExtentions.add("midi");
        audioExtentions.add("rmi");
        audioExtentions.add("xmi");
        audioExtentions.add("ogg");
        audioExtentions.add("vqf");
        audioExtentions.add("tvq");
        audioExtentions.add("mod");
        audioExtentions.add("ape");
        audioExtentions.add("aiff");
        audioExtentions.add("au");
        audioExtentions.add("real");
        return audioExtentions;
    }

    public static List<String> getVideoExtensions() {
        ArrayList<String> videoExtentions = new ArrayList<String>();
        videoExtentions.add("rmvb");
        videoExtentions.add("wmv");
        videoExtentions.add("asf");
        videoExtentions.add("avi");
        videoExtentions.add("3gp");
        videoExtentions.add("asf");
        videoExtentions.add("mpg");
        videoExtentions.add("mkv");
        videoExtentions.add("mp4");
        videoExtentions.add("dvd");
        videoExtentions.add("ogm");
        videoExtentions.add("asx");
        videoExtentions.add("mov");
        videoExtentions.add("m4v");
        videoExtentions.add("dat");
        videoExtentions.add("flv");
        return videoExtentions;
    }

    private static List<String> getTextOften() {
        ArrayList<String> textExtentions = new ArrayList<String>();
        textExtentions.add("doc");
        textExtentions.add("xls");
        textExtentions.add("ppt");
        textExtentions.add("pdf");
        return textExtentions;
    }

    private static List<String> getPictureOften() {
        ArrayList<String> pictureExtentions = new ArrayList<String>();
        pictureExtentions.add("jpg");
        pictureExtentions.add("png");
        pictureExtentions.add("jpeg");
        pictureExtentions.add("bmp");
        return pictureExtentions;
    }

    private static List<String> getAudioOften() {
        ArrayList<String> audioExtentions = new ArrayList<String>();
        audioExtentions.add("wav");
        audioExtentions.add("mp3");
        audioExtentions.add("ra");
        audioExtentions.add("rma");
        return audioExtentions;
    }

    private static List<String> getVideoOften() {
        ArrayList<String> videoExtentions = new ArrayList<String>();
        videoExtentions.add("rmvb");
        videoExtentions.add("wmv");
        videoExtentions.add("avi");
        videoExtentions.add("mkv");
        return videoExtentions;
    }

    public static List<String> getSuffixesByType(FileTypeEnum type) {
        ArrayList<String> extentions = new ArrayList<String>();
        switch (1.$SwitchMap$com$digiwin$dap$middleware$dmc$obsolete$domain$query$FileTypeEnum[type.ordinal()]) {
            case 5: {
                return extentions;
            }
            case 1: {
                extentions.addAll(FileUtil.getTextOften());
                break;
            }
            case 2: {
                extentions.addAll(FileUtil.getPictureOften());
                break;
            }
            case 3: {
                extentions.addAll(FileUtil.getAudioOften());
                break;
            }
            case 4: {
                extentions.addAll(FileUtil.getVideoOften());
                break;
            }
            case 6: {
                break;
            }
        }
        extentions.add("\u5176\u4ed6");
        return extentions;
    }

    public static List<String> getFullTypes(List<String> types) {
        HashSet<String> hashTypes = new HashSet<String>(types);
        types.clear();
        if (hashTypes.contains("doc") || hashTypes.contains("docx")) {
            hashTypes.remove("doc");
            hashTypes.remove("docx");
            hashTypes.add("doc");
            hashTypes.add("docx");
        }
        if (hashTypes.contains("xls") || hashTypes.contains("xlsx")) {
            hashTypes.remove("xls");
            hashTypes.remove("xlsx");
            hashTypes.add("xls");
            hashTypes.add("xlsx");
        }
        if (hashTypes.contains("ppt") || hashTypes.contains("pptx")) {
            hashTypes.remove("ppt");
            hashTypes.remove("pptx");
            hashTypes.add("ppt");
            hashTypes.add("pptx");
        }
        types.addAll(hashTypes);
        return types;
    }

    public static List<String> getSuffixes(FileTypeEnum type, List<String> suffixes) {
        if (type == FileTypeEnum.TEXT) {
            if ((suffixes = FileUtil.getFullTypes(suffixes)).contains("\u5176\u4ed6")) {
                suffixes.remove("\u5176\u4ed6");
                suffixes.addAll(FileUtil.getFileTypeOther((FileTypeEnum)type));
            }
        } else if (suffixes.contains("\u5176\u4ed6")) {
            suffixes.remove("\u5176\u4ed6");
            suffixes.addAll(FileUtil.getFileTypeOther((FileTypeEnum)type));
        }
        return suffixes;
    }
}

