/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.util;

import com.digiwin.dap.middleware.dmc.constant.BaseField;
import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class IdUtil {
    private static final List<String> ROOT_DIR = new /* Unavailable Anonymous Inner Class!! */;

    public static boolean isRootDir(String dirId) {
        return ROOT_DIR.contains(dirId);
    }

    public static boolean isRootDir(UUID dirId) {
        return dirId == null || BaseField.EMPTY_UUID.equals(dirId);
    }

    public static UUID getDirId(String dirId) {
        if (IdUtil.isRootDir((String)dirId)) {
            return BaseField.EMPTY_UUID;
        }
        return IdUtil.uuid((String)dirId);
    }

    public static UUID getDirId(UUID dirId) {
        if (IdUtil.isRootDir((UUID)dirId)) {
            return BaseField.EMPTY_UUID;
        }
        return dirId;
    }

    public static String getDirectoryId(String dirId) {
        if (IdUtil.isRootDir((String)dirId)) {
            return "00000000-0000-0000-0000-000000000000";
        }
        return dirId;
    }

    public static String getDirectoryId(UUID dirId) {
        if (IdUtil.isRootDir((UUID)dirId)) {
            return "00000000-0000-0000-0000-000000000000";
        }
        return dirId.toString();
    }

    public static UUID uuid(String id) {
        try {
            return UUID.fromString(id);
        }
        catch (Exception exception) {
            throw new BusinessException((ErrorHandler)I18nError.INVALID_ID_UUID, new Object[]{id});
        }
    }

    public static UUID uuidOrNull(Object id) {
        try {
            return UUID.fromString(id.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<UUID> validUuid(List<?> ids) {
        return ids.stream().map(IdUtil::uuidOrNull).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

