/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.util;

import com.digiwin.dap.middleware.dmc.domain.ImageInfo;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageUtil {
    public static byte[] scaleImage(byte[] imageByte, ImageInfo imageInfo) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(imageByte);
            BufferedImage srcImage = ImageIO.read(in);
            int srcWidth = (int)((double)(srcImage.getWidth(null) * imageInfo.getScale()) / 100.0);
            int srcHeight = (int)((double)(srcImage.getHeight(null) * imageInfo.getScale()) / 100.0);
            BufferedImage bufferedImage = new BufferedImage(srcWidth, srcHeight, 1);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (imageInfo.isRound()) {
                bufferedImage.getGraphics().drawImage(srcImage.getScaledInstance(srcWidth, srcHeight, 4), 0, 0, null);
                ImageIO.write((RenderedImage)bufferedImage, imageInfo.getFormat(), out);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(out.toByteArray());
                BufferedImage image = ImageIO.read(inputStream);
                BufferedImage buffered = new BufferedImage(srcWidth, srcHeight, 2);
                Graphics2D g2 = buffered.createGraphics();
                g2.setComposite(AlphaComposite.Src);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(Color.WHITE);
                g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, srcWidth, srcHeight, imageInfo.getCornerRadius(), imageInfo.getCornerRadius()));
                g2.setComposite(AlphaComposite.SrcAtop);
                g2.drawImage((Image)image, 0, 0, null);
                g2.dispose();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)buffered, imageInfo.getFormat(), outputStream);
                return outputStream.toByteArray();
            }
            bufferedImage.getGraphics().drawImage(srcImage.getScaledInstance(srcWidth, srcHeight, 4), 0, 0, null);
            ImageIO.write((RenderedImage)bufferedImage, imageInfo.getFormat(), out);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] imageRounded(byte[] imageByte, ImageInfo imageInfo) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(imageByte);
            BufferedImage srcImage = ImageIO.read(in);
            int srcWidth = srcImage.getWidth(null);
            int srcHeight = srcImage.getHeight(null);
            BufferedImage bufferedImage = new BufferedImage(srcWidth, srcHeight, 2);
            Graphics2D g2 = bufferedImage.createGraphics();
            g2.setComposite(AlphaComposite.Src);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(Color.WHITE);
            g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, srcWidth, srcHeight, imageInfo.getCornerRadius(), imageInfo.getCornerRadius()));
            g2.setComposite(AlphaComposite.SrcAtop);
            g2.drawImage((Image)srcImage, 0, 0, null);
            g2.dispose();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", out);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] createImageClip(byte[] imageByte, ImageInfo imageInfo) {
        try {
            BufferedImage handleImage;
            int x;
            int y;
            ByteArrayInputStream in = new ByteArrayInputStream(imageByte);
            BufferedImage srcImage = ImageIO.read(in);
            Integer width = srcImage.getWidth();
            Integer height = srcImage.getHeight();
            double i = (double)width.intValue() / (double)height.intValue();
            double j = (double)imageInfo.getWidth() / (double)imageInfo.getHeight();
            int[] d = new int[2];
            if (i > j) {
                d[1] = imageInfo.getHeight();
                d[0] = (int)((double)imageInfo.getHeight() * i);
                y = 0;
                x = (d[0] - imageInfo.getWidth()) / 2;
            } else {
                d[0] = imageInfo.getWidth();
                d[1] = (int)((double)imageInfo.getWidth() / i);
                x = 0;
                y = (d[1] - imageInfo.getHeight()) / 2;
            }
            if (imageInfo.isRound()) {
                BufferedImage newImage = new BufferedImage(d[0], d[1], srcImage.getType());
                Graphics g = newImage.getGraphics();
                g.drawImage(srcImage, 0, 0, d[0], d[1], null);
                g.dispose();
                newImage = newImage.getSubimage(x, y, imageInfo.getWidth(), imageInfo.getHeight());
                int newWidth = newImage.getWidth(null);
                int newHeight = newImage.getHeight(null);
                handleImage = new BufferedImage(newWidth, newHeight, 2);
                Graphics2D g2 = handleImage.createGraphics();
                g2.setComposite(AlphaComposite.Src);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(Color.WHITE);
                g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, imageInfo.getWidth(), imageInfo.getHeight(), imageInfo.getCornerRadius(), imageInfo.getCornerRadius()));
                g2.setComposite(AlphaComposite.SrcAtop);
                g2.drawImage((Image)newImage, 0, 0, null);
                g2.dispose();
            } else {
                handleImage = new BufferedImage(d[0], d[1], srcImage.getType());
                Graphics g = handleImage.getGraphics();
                g.drawImage(srcImage, 0, 0, d[0], d[1], null);
                g.dispose();
                handleImage = handleImage.getSubimage(x, y, imageInfo.getWidth(), imageInfo.getHeight());
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)handleImage, imageInfo.getFormat(), out);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] scaleCreate(byte[] imageByte, ImageInfo imageInfo) {
        try {
            BufferedImage handleImage;
            ByteArrayInputStream in = new ByteArrayInputStream(imageByte);
            BufferedImage srcImage = ImageIO.read(in);
            Integer width = srcImage.getWidth();
            Integer height = srcImage.getHeight();
            double i = (double)width.intValue() / (double)height.intValue();
            double j = (double)imageInfo.getWidth() / (double)imageInfo.getHeight();
            int[] d = new int[2];
            if (i > j) {
                d[1] = imageInfo.getHeight();
                d[0] = (int)((double)imageInfo.getHeight() * i);
            } else {
                d[0] = imageInfo.getWidth();
                d[1] = (int)((double)imageInfo.getWidth() / i);
            }
            if (imageInfo.isRound()) {
                BufferedImage newImage = new BufferedImage(d[0], d[1], srcImage.getType());
                Graphics g = newImage.getGraphics();
                g.drawImage(srcImage, 0, 0, d[0], d[1], null);
                g.dispose();
                int srcWidth = newImage.getWidth(null);
                int srcHeight = newImage.getHeight(null);
                handleImage = new BufferedImage(srcWidth, srcHeight, 2);
                Graphics2D g2 = handleImage.createGraphics();
                g2.setComposite(AlphaComposite.Src);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(Color.WHITE);
                g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, srcWidth, srcHeight, imageInfo.getCornerRadius(), imageInfo.getCornerRadius()));
                g2.setComposite(AlphaComposite.SrcAtop);
                g2.drawImage((Image)newImage, 0, 0, null);
                g2.dispose();
            } else {
                handleImage = new BufferedImage(d[0], d[1], srcImage.getType());
                Graphics g = handleImage.getGraphics();
                g.drawImage(srcImage, 0, 0, d[0], d[1], null);
                g.dispose();
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)handleImage, imageInfo.getFormat(), out);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

